﻿$option = '';
foreach($arg in $args) {
    if($arg -match '^[-/](un)?install$') {
        $option = $arg;
        break;
    }
    else {
        Write-Error "Unbekannter Parameter: '$arg'.";
        exit;
    }
}
if($option -ne '') {
    # Laufen wir mit vollen Rechten? Sonst neu starten als Admin
    $identity = [System.Security.Principal.WindowsIdentity]::GetCurrent()
    $princ = New-Object System.Security.Principal.WindowsPrincipal($identity)
    if(-not $princ.IsInRole([System.Security.Principal.WindowsBuiltInRole]::Administrator)) {
        $newProcess = new-object System.Diagnostics.ProcessStartInfo "PowerShell";
        $newProcess.Arguments = '"' + $myInvocation.MyCommand.Definition + '" ' + $option;
        $newProcess.Verb = "runas";
        [System.Diagnostics.Process]::Start($newProcess);
        exit;
    }
    if(-not ($option -match 'uninstall')) {
        "Installiere ..."
        # Event-Log und -Quelle einrichten
        New-EventLog -LogName PowerShell-Skripte -Source IP-Wächter -ErrorAction SilentlyContinue

        # Dieses Skript als geplante Aufgabe eintragen
        $pwSecure = Read-Host "Bitte geben Sie Ihr Windows-Kennwort ein" -AsSecureString
        if($pwSecure) {
            $passwd = [Runtime.InteropServices.Marshal]::PtrToStringAuto([Runtime.InteropServices.Marshal]::SecureStringToBSTR($pwSecure));
        }
        else {
            exit;
        }
        $script = '-NoLogo -NonInteractive -WindowStyle Hidden -File "' + $MyInvocation.MyCommand.Definition + '"';
        $action = New-ScheduledTaskAction -Execute 'powershell' -Argument $script;
        $trigger = New-ScheduledTaskTrigger -Once -At ((Get-Date).AddSeconds(10)) -RepetitionInterval (New-TimeSpan -Hours 1) -RepetitionDuration ([TimeSpan]::MaxValue);
        $settings = New-ScheduledTaskSettingsSet -DontStopIfGoingOnBatteries -DontStopOnIdleEnd -Hidden -StartWhenAvailable -RunOnlyIfNetworkAvailable;
        $task = New-ScheduledTask -Action $action -Trigger $trigger -Settings $settings;
        Register-ScheduledTask IP-Wächter -InputObject $task -User ($identity.Name) -Password $passwd;
        Remove-Variable passwd;
        "Fertig."
        pause;
        exit;
    }
    else {
        "Deinstalliere ..."
        Unregister-ScheduledTask IP-Wächter;
        "Fertig."
        pause;
        exit;
    }
}

$ip = '';
$response = Invoke-WebRequest -Uri http://checkip.dyndns.com/;
if($response) {
    if($response.Content -match '\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}') {
        $ip = $matches[0];
    }
}

if($ip) {
    Write-EventLog -LogName PowerShell-Skripte -Source IP-Wächter -Category 0 -EventId 1 -Message "Externe IP-Adresse: $ip"
}
else {
    Write-EventLog -LogName PowerShell-Skripte -Source IP-Wächter -Category 0 -EventId 99 -Message "Externe IP-Adresse konnte nicht ermittelt werden."
}
