package com.linkesoft.ctlongitude;

import java.io.IOException;
import java.util.*;

import org.apache.http.*;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.*;
import org.apache.http.protocol.*;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

import android.app.PendingIntent;
import android.content.*;
import android.location.*;
import android.net.*;
import android.os.AsyncTask;
import android.util.Log;

import com.google.android.gms.auth.*;
import com.google.android.gms.common.*;

public class LocationReceiver extends BroadcastReceiver {

	private static final float MIN_DISTANCE_M = 0; // m, 0 fr fortlaufend
	private static final long MIN_TIME_MS = 5 * 60 * 1000; // 5min
	private Context context;

	@Override
		public void onReceive(Context context, Intent intent) {
			this.context = context;
			if (intent.hasExtra(LocationManager.KEY_LOCATION_CHANGED)) {
				// neue Position
				Location location = (Location) intent.getExtras().get(LocationManager.KEY_LOCATION_CHANGED);
				SendLocationTask locationTask = new SendLocationTask();
				locationTask.execute(location);
		} else {
			// Netzwerknderung
			ConnectivityManager connectivityManager = (ConnectivityManager) context
					.getSystemService(Context.CONNECTIVITY_SERVICE);
			NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();

			if (networkInfo != null && networkInfo.isConnected()) {
				Log.v(getClass().getSimpleName(), "Network available, start location updates");
				startPositionUpdates(context);

			} else {
				Log.v(getClass().getSimpleName(), "No network, stop location updates");
				stopPositionUpdates(context);
			}
		}
	}

	public static void startPositionUpdates(Context context) {
		int status = GooglePlayServicesUtil.isGooglePlayServicesAvailable(context);
		if (status != ConnectionResult.SUCCESS) {
			Log.e("LocationReceiver",
					"Google Play Services not available " + GooglePlayServicesUtil.getErrorString(status));
			return;
		}
		LocationManager locationManager = (LocationManager) context.getSystemService(Context.LOCATION_SERVICE);
		PendingIntent broadcastIntent = PendingIntent.getBroadcast(context, 0, new Intent(context, LocationReceiver.class),
				PendingIntent.FLAG_UPDATE_CURRENT);
		Criteria criteria = new Criteria();
		criteria.setAccuracy(Criteria.ACCURACY_FINE);
		locationManager.requestLocationUpdates(MIN_TIME_MS, MIN_DISTANCE_M, criteria, broadcastIntent);
	}

	public static void stopPositionUpdates(Context ctx) {
		LocationManager locationManager = (LocationManager) ctx.getSystemService(Context.LOCATION_SERVICE);
		PendingIntent broadcastIntent = PendingIntent.getBroadcast(ctx, 0, new Intent(ctx, LocationReceiver.class),
				PendingIntent.FLAG_UPDATE_CURRENT);
		locationManager.removeUpdates(broadcastIntent);
	}

	private class SendLocationTask extends AsyncTask<Location, Void, Boolean> {
		@Override
		protected Boolean doInBackground(Location... params) {
			Location currentLocation = params[0];
			Log.v(getClass().getSimpleName(), "sending location update " + currentLocation);
			String oauthToken;
			// hole OAuth token in einem Hintergrund-Prozess
			try {
				oauthToken = GoogleAuthUtil.getTokenWithNotification(context, MainActivity.getAccountName(context),
						MainActivity.OAUTH_CLIENT_SCOPE,null);
			} catch (UserRecoverableNotifiedException e) {
				Log.i(getClass().getSimpleName(), "Token expired, user prompted", e);
				return Boolean.TRUE;
			} catch (IOException e) {
				Log.i(getClass().getSimpleName(), "Network error, will try again with next update", e);
				return Boolean.TRUE;
			} catch (GoogleAuthException e) {
				Log.e(getClass().getSimpleName(), "Unrecoverable authentication error, will stop location updates", e);
				LocationReceiver.stopPositionUpdates(context);
				return Boolean.TRUE;
			} 
			// eigentlicher Request mit Positionsdaten
			// API erwartet UrlEncodedFormEntity
			HttpContext httpContext = new BasicHttpContext();
			HttpParams httpParameters = new BasicHttpParams();
			HttpClient httpClient = new DefaultHttpClient(httpParameters);
			HttpPost httpPost = new HttpPost(MainActivity.POSITION_URL);
			List<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
			nameValuePairs.add(new BasicNameValuePair("as_array", "true"));
			nameValuePairs.add(new BasicNameValuePair("oauth[clientId]", MainActivity.CLIENT_ID));
			nameValuePairs.add(new BasicNameValuePair("oauth[token]", oauthToken));
			nameValuePairs.add(new BasicNameValuePair("userid", MainActivity.getAccountUserId(context)));
			nameValuePairs.add(new BasicNameValuePair("lat", String.valueOf(currentLocation.getLatitude())));
			nameValuePairs.add(new BasicNameValuePair("lng", String.valueOf(currentLocation.getLongitude())));
			nameValuePairs.add(new BasicNameValuePair("accuracy", String.valueOf(currentLocation.getAccuracy())));
			nameValuePairs.add(new BasicNameValuePair("heading", String.valueOf(currentLocation.getBearing())));
			nameValuePairs.add(new BasicNameValuePair("timestamp", String.valueOf(currentLocation.getTime() / 1000L)));
			nameValuePairs.add(new BasicNameValuePair("speed", String.valueOf(currentLocation.getSpeed() * 3.6))); // m/s -> km/h
			nameValuePairs.add(new BasicNameValuePair("altitude", String.valueOf(currentLocation.getAltitude())));

			try {
				httpPost.setEntity(new UrlEncodedFormEntity(nameValuePairs));
				HttpResponse response = httpClient.execute(httpPost, httpContext);
				HttpEntity entity = response.getEntity();
				String result = EntityUtils.toString(entity);
				JSONObject obj = new JSONObject(result);
				Log.v(getClass().getSimpleName(), "Result JSON: " + obj);
				if (!obj.getString("status").equals("ok")) {
					Log.e(getClass().getSimpleName(), "Error sending position to server " + result);
					return Boolean.TRUE;
				}
				Log.v(getClass().getSimpleName(), "Location update sent to server");
			} catch (final Exception e) {
				Log.e(getClass().getSimpleName(), "Could not send position", e);

			}
			return Boolean.TRUE;
		}
	}
}
