<?php
header('Content-type: image/svg+xml; charset=utf-8');
echo "<?xml version='1.0'?>\n";
$settings = array(
	'r' => 1,
	'g' => 1,
	'b' => 1,
	'contrast' => 1
);
foreach ($settings as $setting => $val) {
	if ($_GET[$setting] && is_numeric($_GET[$setting])) $settings[$setting] = floatval($_GET[$setting]);
}
?>
<svg height="0" xmlns="http://www.w3.org/2000/svg">
  <filter id="brightness">
    <feComponentTransfer>
      <feFuncR type="linear" slope="<?php echo $settings['r'] ?>"/>
      <feFuncG type="linear" slope="<?php echo $settings['g'] ?>"/>
      <feFuncB type="linear" slope="<?php echo $settings['b'] ?>"/>
    </feComponentTransfer>
  </filter>

  <filter id="contrast">
    <feComponentTransfer>
      <feFuncR type="linear" slope="<?php echo $settings['contrast']; ?>" intercept="-(0.5 * <?php echo $settings['contrast']; ?>) + 0.5"/>
      <feFuncG type="linear" slope="<?php echo $settings['contrast']; ?>" intercept="-(0.5 * <?php echo $settings['contrast']; ?>) + 0.5"/>
      <feFuncB type="linear" slope="<?php echo $settings['contrast']; ?>" intercept="-(0.5 * <?php echo $settings['contrast']; ?>) + 0.5"/>
    </feComponentTransfer>
  </filter>
</svg>