﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO.Ports;

namespace RGB_Regler
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            string[] ports = SerialPort.GetPortNames();
            foreach (string port in ports) listBox1.Items.Add(port);
            serialPort1.PortName = System.Convert.ToString(listBox1.Items[0]);
            OpenPort();
            ScrollEventArgs a = new ScrollEventArgs(ScrollEventType.First, 255);
            vScrollBar1_Scroll(sender, a);
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (serialPort1.IsOpen)
                try { serialPort1.Close(); }
                catch (System.IO.IOException error)
                {
                    //
                }
        }

        private void vScrollBar1_Scroll(object sender, ScrollEventArgs e)
        {
            byte[] puffer = new byte[] {System.Convert.ToByte(255 - vScrollBar1.Value), System.Convert.ToByte(255 - vScrollBar2.Value), 
                System.Convert.ToByte(255 - vScrollBar3.Value) };
            if (!serialPort1.IsOpen) OpenPort(); else
                try { serialPort1.Write(puffer, 0, 3); }
            catch (System.IO.IOException) {
                label6.Text = "Fehler!";
            }
            if (label6.Text == "Fehler!") try
                {
                    serialPort1.Close();
                    OpenPort();
                }
                catch (System.IO.IOException)
                {
                    //Test
                }
            label1.Text = puffer[0].ToString();
            label2.Text = puffer[1].ToString();
            label3.Text = puffer[2].ToString();
            panel1.BackColor = Color.FromArgb(255, puffer[0], puffer[1], puffer[2]);
        }

        private Boolean OpenPort()
        {
            try
            {
                serialPort1.Open();
                label6.Text = "Blau";
                return (true);
            }
            catch (UnauthorizedAccessException error)
            {
                label6.Text = "COM-Port belegt!";
                return (false);
            }

            catch (System.IO.IOException err2)
            {
                label6.Text = "COM-Port nicht vorhanden!";
                return (false);
            }           

        }

        private void listBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                serialPort1.Close();
            }
            catch
            {

            }
            serialPort1.PortName = System.Convert.ToString(listBox1.Items[listBox1.SelectedIndex]);
            OpenPort();
        }
    }
}
