// ponder0914.cpp : Definiert den Einstiegspunkt fr die Konsolenanwendung.
//
/*
ln(x) = sum_k=0^inf (2 / (2k+1)* ((1-x)/(1+x))^(2k+1)
ln(2) = sum k=0^inf (2/(2k+1)* (1/3) ^ (2k+1)= 2*(1/1/3^1+ 1/3/3^3+ 1/5/3^5 + ...
3^1024 *ln(2)= 2*(3^1023/1 + 3^1021/3+3^1019/5+3^1017/7+...

1.53137715531012716440
*/

#include "targetver.h"
#include <stdio.h>
#include <tchar.h>
#include <math.h>
#include <float.h>
#include <limits.h>


#pragma fenv_access (on)


int b_to_n_mod_a(int b, int n, int a) {
	int res = 1;
	for (int i = 0; i < n; i++)  {
		res *= b;
		res %= a;
	}
	return res;
}


double _3_to_n(int n) { // for n <=40
	long long res = 1;
	for (int i = 0; i < n; i++)  {
		res *= 3LL;
	}
	return double(res);
}

double inv_3_to_n(int n) { // for n <=40
	double res = 1.0;
	for (int i = 0; i < n; i++)  {
		res /= 3.0;
	}
	return double(res);
}


double _3f_to_n(int n) { // 		
	return pow(3.0, n);
}


double frac_3_to_n_div_a(int n, int a) {
	int res = 1;
	if (n >= 0) {
		for (int i = 0; i < n; i++)  {
			res *= 3;
			res %= a;
		}
		return (double)res / a;
	}
	else
		return pow(3.0, n) / a;
}


double calc0()
{
	double f;
	double sum = 0.0;
	for (int k = 0; k < 524; k++) {
		int n = 2 * k + 1;
		f = frac_3_to_n_div_a(1024 - n, n);
		sum += f;
	}
	sum *= 2;
	return sum - (int)sum;
}


double calc1(int r)
{
	double f;
	double sum = 0.0;
	for (int k = 0; k < 512 + r; k++) {
		int n = 2 * k + 1;
		f = frac_3_to_n_div_a(1024 - n, n);
		sum += f;
		if (sum > 1.0) sum -= 1.0;
	}
	sum *= 2;
	if (sum > 1.0) sum -= 1.0;
	return sum;
}



double calc2()
{
	double f;
	double sum = 0.0;
	double kahan = 0.0;
	double y;
	double t;

	for (int k = 0; k < 524; k++) {
		int n = 2 * k + 1;
		f = frac_3_to_n_div_a(1024 - n, n);
		y = f - kahan;
		t = sum + y;
		kahan = (t - sum) - y;
		sum = t;
	}
	sum *= 2;
	return sum - (int)sum;
}


double geosum(int from, int to, double q) {
	if (to == INT_MAX) return (pow(q, from) / (1 - q));
	else return (pow(q, from) - pow(q, to + 1)) / (1 - q);
}


int _tmain(int argc, _TCHAR* argv[])
{
	double s;
	double minrest = 0.0;
	double maxrest;

	int r = 0;

	_controlfp(_RC_UP, _MCW_RC);

	do {
		int n = 2 * r + 1 + 1024;
		maxrest = 2.0 / 3.0 / n * geosum(r, INT_MAX, 1.0 / 9.0);
		if (maxrest < 1e-15) break;
		r++;
	} while (true);

	printf("%d %15.15lg\n", r, maxrest);

	_controlfp(_RC_DOWN, _MCW_RC);

	s = calc1(r) + minrest;
	printf("%15.15lf %15.15lf  \n", s, exp(s));
	_controlfp(_RC_UP, _MCW_RC);
	s = calc1(r) + maxrest;
	printf("%15.15lf %15.15lf  \n", s, exp(s));
	return 0;
}

