﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.PowerShell.Host.ISE;
using System.Globalization;

namespace PSFindAll
{
  /// <summary>
  /// Interaktionslogik für FindAllAddOn.xaml
  /// </summary>
  public partial class FindAllAddOn : UserControl, IAddOnToolHostObject
  {
    public FindAllAddOn()
    {
      InitializeComponent();
    }

    #region IAddOnToolHostObject interface

    public ObjectModelRoot HostObject { get; set; }

    #endregion

    ISEFile _lastFile;

    private void btnSearch_Click(object sender, RoutedEventArgs e)
    {
      lstFound.Items.Clear();
      _lastFile = HostObject.CurrentPowerShellTab.Files.SelectedFile;
      if(_lastFile != null) {
        var lines = _lastFile.Editor.Text.Split(new string[] { "\r\n" }, StringSplitOptions.None);
        string search = edtSearch.Text;
        for(int i = 0; i < lines.Count(); ++i) {
          if(lines[i].IndexOf(search, StringComparison.InvariantCultureIgnoreCase) != -1) {
            FindEntry fe = new FindEntry {
              LineText = lines[i],
              LineNumber = i + 1,
              SearchText = search
            };
            lstFound.Items.Add(fe);
          }
        }
      }
    }

    private void lstFound_MouseDoubleClick(object sender, MouseButtonEventArgs e)
    {
      if(HostObject.CurrentPowerShellTab.Files.Contains(_lastFile)) {
        HostObject.CurrentPowerShellTab.Files.SelectedFile = _lastFile;
        ISEEditor editor = _lastFile.Editor;
        editor.Focus();
        FindEntry entry = lstFound.SelectedItem as FindEntry;
        if(entry != null) {
          editor.SetCaretPosition(entry.LineNumber, 1);
          editor.SelectCaretLine();
          string line = editor.SelectedText;
          int pos = line.IndexOf(entry.SearchText, StringComparison.InvariantCultureIgnoreCase);
          if(pos != -1) {
            editor.Select(entry.LineNumber, pos + 1, entry.LineNumber, pos + entry.SearchText.Length + 1);
          }
        }
      }
    }
  }

  class FindEntry
  {
    public int LineNumber { get; set; }
    public string LineText { get; set; }
    public string SearchText { get; set; }
    private Geometry _rendered = null;
    public Geometry RenderedText
    {
      get
      {
        if(_rendered == null)
          RenderText();
        return _rendered;
      }
    }
    private void RenderText()
    {
      string numText = string.Format("{0,3:D}", LineNumber);
      int numLength = numText.Length + 2;
      string text = string.Format(".{0} {1}", numText, LineText);
      FormattedText ft = new FormattedText(text, CultureInfo.CurrentUICulture, FlowDirection.LeftToRight, new Typeface("Courier New"), 12, Brushes.Black);
      ft.SetFontStyle(FontStyles.Italic, 0, numLength - 1);
      int pos = LineText.IndexOf(SearchText, 0, StringComparison.InvariantCultureIgnoreCase);
      while(pos != -1) {
        ft.SetFontWeight(FontWeights.Bold, pos + numLength, SearchText.Length);
        pos = LineText.IndexOf(SearchText, pos + SearchText.Length, StringComparison.InvariantCultureIgnoreCase);
      }
      _rendered = ft.BuildGeometry(new Point(0, 0));
    }
  }
}
