using System;
using MonoTouch.Foundation;
using MonoTouch.UIKit;
using System.CodeDom.Compiler;
using System.Collections.Generic;

namespace ConfAppiOS
{
	partial class AgendaViewController : UITableViewController
	{
		public List<AgendaEntry> Agenda { get; set; }

		public AgendaViewController (IntPtr handle) : base (handle)
		{
		}

		public override void ViewDidLoad ()
		{
			base.ViewDidLoad ();
			this.TableView.Source = new AgendaTableViewSource(this.Agenda);
		}
	}

	public class AgendaTableViewSource : UITableViewSource
	{
		private List<AgendaEntry> _agenda;

		public AgendaTableViewSource (List<AgendaEntry> agenda)
		{
			_agenda = agenda;
		}

		public override UITableViewCell GetCell (UITableView tableView, NSIndexPath indexPath)
		{
			UITableViewCell cell = tableView.DequeueReusableCell ("agendaCell");
			var entry = _agenda [indexPath.Row];
			cell.TextLabel.Text = entry.Time + "  " + entry.Track;
			cell.TextLabel.Font = UIFont.SystemFontOfSize (15f);
			return cell;
		}

		public override int RowsInSection (UITableView tableview, int section)
		{
			return _agenda.Count;
		}
	}
}
