using System;
using MonoTouch.Foundation;
using MonoTouch.UIKit;
using System.CodeDom.Compiler;

namespace ConfAppiOS
{
	partial class SessionDetailsViewController : UITableViewController
	{
		public Session Session { get; set; }

		public SessionDetailsViewController (IntPtr handle) : base (handle)
		{
		}

		public override void ViewDidLoad ()
		{
			base.ViewDidLoad ();
			if (this.Session != null)
			{
				this.Title = this.Session.Title;
				this.descriptionTextView.Text = this.Session.Description;
			}
			this.votingSlider.ValueChanged += this.OnValueChanged;
		}

		private void OnValueChanged (object sender, EventArgs e)
		{
			var text = "";
			var value = (int)this.votingSlider.Value;
			switch (value)
			{
				case 0:
					text = "(nicht bewertet)";
					break;
				case 1:
					text = "ungenügend";
					break;
				case 2:
					text = "mangelhaft";
					break;
				case 3:
					text = "ausreichend";
					break;
				case 4:
					text = "befriedigend";
					break;
				case 5:
					text = "gut";
					break;
				case 6:
					text = "sehr gut";
					break;
			}
			this.votingLabel.Text = text;
		}
	}
}
