using System;
using MonoTouch.Foundation;
using MonoTouch.UIKit;
using System.CodeDom.Compiler;
using System.Collections.Generic;

namespace ConfAppiOS
{
	partial class SpeakersViewController : UITableViewController
	{
		public List<Speaker> Speakers { get; set; }

		public SpeakersViewController (IntPtr handle) : base (handle)
		{
		}

		public override void ViewDidLoad ()
		{
			base.ViewDidLoad ();
			this.TableView.Source = new SpeakersTableViewSource(this.Speakers);
		}

		public override void PrepareForSegue (UIStoryboardSegue segue, NSObject sender)
		{
			base.PrepareForSegue (segue, sender);
			if (segue.Identifier == "speakerDetailsSegue")
			{
				var source = TableView.Source as SpeakersTableViewSource;
				var rowPath = TableView.IndexPathForSelectedRow;
				var item = this.Speakers[rowPath.Row];
				((SpeakerDetailsViewController)segue.DestinationViewController).Speaker = item;
			}
		}
	}

	public class SpeakersTableViewSource : UITableViewSource
	{
		private List<Speaker> _speakers;

		public SpeakersTableViewSource (List<Speaker> agenda)
		{
			_speakers = agenda;
		}

		public override UITableViewCell GetCell (UITableView tableView, NSIndexPath indexPath)
		{
			UITableViewCell cell = tableView.DequeueReusableCell ("speakerCell");
			cell.TextLabel.Text = _speakers [indexPath.Row].Name;
			cell.Accessory = UITableViewCellAccessory.DisclosureIndicator;
			return cell;
		}

		public override int RowsInSection (UITableView tableview, int section)
		{
			return _speakers.Count;
		}
	}
}
