// Copyright (c) 2014-2015 Oliver Lau <ola@ct.de>, Heise Zeitschriften Verlag
// All rights reserved.

#ifndef __VARIANT_H_
#define __VARIANT_H_

#include <string>
#include <memory>

class VariantPrivate;

class Variant {
public:
  enum Type {
    V_NONE,
    V_CHAR,
    V_UCHAR,
    V_INT,
    V_UINT,
    V_LONG,
    V_ULONG,
    V_DOUBLE,
    V_FLOAT,
    V_PTR,
    V_STRING
  };

  Variant(void);
  Variant(const Variant &);
  Variant(char);
  Variant(unsigned char);
  Variant(int);
  Variant(unsigned int);
  Variant(long);
  Variant(unsigned long);
  Variant(double);
  Variant(float);
  Variant(char *);
  Variant(void *);
  Variant(const std::string &);

  Type type(void) const;

  bool isValid(void) const;
  bool isChar(void) const;
  bool isUChar(void) const;
  bool isInteger(void) const;
  bool isUInteger(void) const;
  bool isLong(void) const;
  bool isULong(void) const;
  bool isFloat(void) const;
  bool isDouble(void) const;
  bool isPointer(void) const;
  bool isString(void) const;

  const std::string &toString(void) const;
  char toChar(void) const;
  unsigned char toUChar(void) const;
  int toInt(void) const;
  unsigned int toUInt(void) const;
  long toLong(void) const;
  unsigned long toULong(void) const;
  float toFloat(void) const;
  double toDouble(void) const;
  void *toPointer(void) const;

  Variant operator=(const Variant&);
  Variant operator=(char);
  Variant operator=(unsigned char);
  Variant operator=(int);
  Variant operator=(unsigned int);
  Variant operator=(long);
  Variant operator=(unsigned long);
  Variant operator=(double);
  Variant operator=(float);
  Variant operator=(char *);
  Variant operator=(void *);
  Variant operator=(const std::string &);

private:
  std::shared_ptr<VariantPrivate> d;
};


#endif
