// Copyright (c) 2014-2015 Oliver Lau <ola@ct.de>, Heise Zeitschriften Verlag
// All rights reserved.

#include "Variant.h"


class VariantPrivate {
public:
  enum Type {
    V_NONE,
    V_CHAR,
    V_UCHAR,
    V_INT,
    V_UINT,
    V_LONG,
    V_ULONG,
    V_DOUBLE,
    V_FLOAT,
    V_PTR,
    V_STRING
  };
  union DataStorage {
    char c;
    unsigned char uc;
    int i;
    unsigned int ui;
    long l;
    unsigned long ul;
    double d;
    float f;
    void *p;
  } data;
  std::string s;
  Type type;
};



Variant::Variant(void)
  : d(new VariantPrivate)
{
  d->type = VariantPrivate::V_NONE;
}


Variant::Variant(char x)
  : d(new VariantPrivate)
{
  d->type = VariantPrivate::V_CHAR;
  d->data.c = x;
}


Variant::Variant(unsigned char x)
  : d(new VariantPrivate)
{
  d->type = VariantPrivate::V_UCHAR;
  d->data.uc = x;
}


Variant::Variant(int x)
  : d(new VariantPrivate)
{
  d->type = VariantPrivate::V_INT;
  d->data.i = x;
}


Variant::Variant(unsigned int x)
  : d(new VariantPrivate)
{
  d->type = VariantPrivate::V_UINT;
  d->data.ui = x;
}


Variant::Variant(long x)
  : d(new VariantPrivate)
{
  d->type = VariantPrivate::V_LONG;
  d->data.l = x;
}


Variant::Variant(unsigned long x)
  : d(new VariantPrivate)
{
  d->type = VariantPrivate::V_ULONG;
  d->data.ul = x;
}


Variant::Variant(double x)
  : d(new VariantPrivate)
{
  d->type = VariantPrivate::V_DOUBLE;
  d->data.d = x;
}


Variant::Variant(float x)
  : d(new VariantPrivate)
{
  d->type = VariantPrivate::V_FLOAT;
  d->data.f = x;
}


Variant::Variant(char *x)
  : d(new VariantPrivate)
{
  d->type = VariantPrivate::V_STRING;
  d->s = x;
}


Variant::Variant(void *x)
  : d(new VariantPrivate)
{
  d->type = VariantPrivate::V_PTR;
  d->data.p = x;
}


Variant::Variant(const std::string &x)
  : d(new VariantPrivate)
{
  d->type = VariantPrivate::V_STRING;
  d->s = x;
}


Variant::Variant(const Variant &other)
  : d(new VariantPrivate)
{
  d->type = other.d->type;
  switch (d->type) {
  case VariantPrivate::V_CHAR:
    d->data.c = other.d->data.c;
    break;
  case VariantPrivate::V_UCHAR:
    d->data.uc = other.d->data.uc;
    break;
  case VariantPrivate::V_INT:
    d->data.i = other.d->data.i;
    break;
  case VariantPrivate::V_UINT:
    d->data.ui = other.d->data.ui;
    break;
  case VariantPrivate::V_LONG:
    d->data.l = other.d->data.l;
    break;
  case VariantPrivate::V_ULONG:
    d->data.ul = other.d->data.ul;
    break;
  case VariantPrivate::V_FLOAT:
    d->data.f = other.d->data.f;
    break;
  case VariantPrivate::V_DOUBLE:
    d->data.d = other.d->data.d;
    break;
  case VariantPrivate::V_PTR:
    d->data.p = other.d->data.p;
    break;
  case VariantPrivate::V_STRING:
    d->s = other.d->s;
    break;
  }
}


Variant Variant::operator=(const Variant &x)
{
  return Variant(x);
}


Variant Variant::operator=(char x)
{
  return Variant(x);
}


Variant Variant::operator=(unsigned char x)
{
  return Variant(x);
}


Variant Variant::operator=(int x)
{
  return Variant(x);
}


Variant Variant::operator=(unsigned int x)
{
  return Variant(x);
}


Variant Variant::operator=(long x)
{
  return Variant(x);
}


Variant Variant::operator=(unsigned long x)
{
  return Variant(x);
}


Variant Variant::operator=(double x)
{
  return Variant(x);
}


Variant Variant::operator=(float x)
{
  return Variant(x);
}


Variant Variant::operator=(char *x)
{
  return Variant(x);
}


Variant Variant::operator=(void *x)
{
  return Variant(x);
}


Variant Variant::operator=(const std::string &x)
{
  return Variant(x);
}


bool Variant::isNull(void) const
{
  return d->type == VariantPrivate::V_NONE;
}


bool Variant::isInteger(void) const
{
  return d->type == VariantPrivate::V_INT;
}


bool Variant::isUInteger(void) const
{
  return d->type == VariantPrivate::V_UINT;
}


bool Variant::isChar(void) const
{
  return d->type == VariantPrivate::V_CHAR;
}


bool Variant::isUChar(void) const
{
  return d->type == VariantPrivate::V_UCHAR;
}


bool Variant::isLong(void) const
{
  return d->type == VariantPrivate::V_LONG;
}


bool Variant::isULong(void) const
{
  return d->type == VariantPrivate::V_ULONG;
}


bool Variant::isFloat(void) const
{
  return d->type == VariantPrivate::V_FLOAT;
}


bool Variant::isDouble(void) const
{
  return d->type == VariantPrivate::V_DOUBLE;
}


bool Variant::isPointer(void) const
{
  return d->type == VariantPrivate::V_PTR;
}


bool Variant::isString(void) const
{
  return d->type == VariantPrivate::V_STRING;
}


const std::string &Variant::toString(void) const
{
  return d->s;
}


char Variant::toChar(void) const
{
  return d->data.c;
}


unsigned char Variant::toUChar(void) const
{
  return d->data.uc;
}


int Variant::toInt(void) const
{
  return d->data.i;
}


unsigned int Variant::toUInt(void) const
{
  return d->data.ui;
}


long Variant::toLong(void) const
{
  return d->data.l;
}


unsigned long Variant::toULong(void) const
{
  return d->data.ul;
}


float Variant::toFloat(void) const
{
  return d->data.f;
}


double Variant::toDouble(void) const
{
  return d->data.d;
}


void *Variant::toPointer(void) const
{
  return d->data.p;
}
