/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;

public class Encoder {
    private static Properties keyboardProps = new Properties();
    private static Properties layoutProps = new Properties();
    private static String version = "2.6.3";
    private static Boolean debug = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        String string = "Hak5 Duck Encoder " + version + "\n\n" + "Usage: duckencode -i [file ..]\t\t\tencode specified file\n" + "   or: duckencode -i [file ..] -o [file ..]\tencode to specified file\n\n" + "Arguments:\n" + "   -i [file ..] \t\tInput File\n" + "   -o [file ..] \t\tOutput File\n" + "   -l [file ..] \t\tKeyboard Layout (us/fr/pt or a path to a properties file)\n\n" + "Script Commands:\n" + "   ALT [key name] (ex: ALT F4, ALT SPACE)\n" + "   CTRL | CONTROL [key name] (ex: CTRL ESC)\n" + "   CTRL-ALT [key name] (ex: CTRL-ALT DEL)\n" + "   CTRL-SHIFT [key name] (ex: CTRL-SHIFT ESC)\n" + "   DEFAULT_DELAY | DEFAULTDELAY [Time in millisecond * 10] (change the delay between each command)\n" + "   DELAY [Time in millisecond * 10] (used to overide temporary the default delay)\n" + "   GUI | WINDOWS [key name] (ex: GUI r, GUI l)\n" + "   REM [anything] (used to comment your code, no obligation :) )\n" + "   ALT-SHIFT (swap language)\n" + "   SHIFT [key name] (ex: SHIFT DEL)\n" + "   STRING [any character of your layout]\n" + "   REPEAT [Number] (Repeat last instruction N times)\n" + "   [key name] (anything in the keyboard.properties)";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (stringArray.length == 0) {
            System.out.println(string);
            System.exit(0);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--gui") || stringArray[i].equals("-g")) {
                System.out.println("Launch GUI");
                continue;
            }
            if (stringArray[i].equals("--help") || stringArray[i].equals("-h")) {
                System.out.println(string);
                continue;
            }
            if (stringArray[i].equals("-i")) {
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-o")) {
                string3 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-l")) {
                string4 = stringArray[++i];
                continue;
            }
            if (stringArray[i].equals("-d")) {
                debug = true;
                continue;
            }
            System.out.println(string);
            break;
        }
        System.out.println("Hak5 Duck Encoder " + version + "\n");
        if (string2 != null) {
            String string5 = null;
            if (string2.contains(".rtf")) {
                try {
                    FileInputStream fileInputStream = new FileInputStream(string2);
                    RTFEditorKit rTFEditorKit = new RTFEditorKit();
                    Document document = rTFEditorKit.createDefaultDocument();
                    rTFEditorKit.read(fileInputStream, document, 0);
                    string5 = document.getText(0, document.getLength());
                    System.out.println("Loading RTF .....\t\t[ OK ]");
                }
                catch (IOException iOException) {
                    System.out.println("Error with input file!");
                }
                catch (BadLocationException badLocationException) {
                    System.out.println("Error with input file!");
                }
            } else {
                FilterInputStream filterInputStream = null;
                try {
                    File file = new File(string2);
                    byte[] byArray = new byte[(int)file.length()];
                    filterInputStream = new DataInputStream(new FileInputStream(file));
                    ((DataInputStream)filterInputStream).readFully(byArray);
                    string5 = new String(byArray);
                    System.out.println("Loading File .....\t\t[ OK ]");
                }
                catch (IOException iOException) {
                    System.out.println("Error with input file!");
                }
                finally {
                    try {
                        filterInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            Encoder.loadProperties(string4 == null ? "us" : string4);
            Encoder.encodeToFile(string5, string3 == null ? "inject.bin" : string3);
        }
    }

    private static void loadProperties(String string) {
        InputStream inputStream;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            inputStream = classLoader.getResourceAsStream("keyboard.properties");
            if (inputStream != null) {
                keyboardProps.load(inputStream);
                inputStream.close();
                System.out.println("Loading Keyboard File .....\t[ OK ]");
            } else {
                System.out.println("Error with keyboard.properties!");
                System.exit(0);
            }
        }
        catch (IOException iOException) {
            System.out.println("Error with keyboard.properties!");
        }
        try {
            inputStream = classLoader.getResourceAsStream(string + ".properties");
            if (inputStream != null) {
                layoutProps.load(inputStream);
                inputStream.close();
                System.out.println("Loading Language File .....\t[ OK ]");
            } else if (new File(string).isFile()) {
                layoutProps.load(new FileInputStream(string));
                System.out.println("Loading Language File .....\t[ OK ]");
            } else {
                System.out.println("External layout.properties non found!");
                System.exit(0);
            }
        }
        catch (IOException iOException) {
            System.out.println("Error with layout.properties!");
            System.exit(0);
        }
    }

    private static void encodeToFile(String string, String string2) {
        Object object;
        int n;
        string = string.replaceAll("\\r", "");
        String[] stringArray = string.split("\n");
        String[] stringArray2 = string.split("\n");
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        System.out.println("Loading DuckyScript .....\t[ OK ]");
        if (debug.booleanValue()) {
            System.out.println("\nParsing Commands:");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                int n4;
                n = 0;
                object = stringArray[i].substring(0, 2);
                if (((String)object).equals("//") || stringArray[i].equals("\n")) continue;
                String[] stringArray3 = stringArray[i].split(" ", 2);
                if (i > 0) {
                    stringArray2 = stringArray[i - 1].split(" ", 2);
                    stringArray2[0].trim();
                    if (stringArray2.length == 2) {
                        stringArray2[1].trim();
                    }
                } else {
                    stringArray2 = stringArray[i].split(" ", 2);
                    stringArray2[0].trim();
                    if (stringArray2.length == 2) {
                        stringArray2[1].trim();
                    }
                }
                stringArray3[0].trim();
                if (stringArray3.length == 2) {
                    stringArray3[1].trim();
                }
                if (stringArray3[0].equals("REM")) continue;
                if (stringArray3[0].equals("REPEAT")) {
                    n3 = Integer.parseInt(stringArray3[1].trim());
                    bl = true;
                } else {
                    bl = false;
                    n3 = 1;
                }
                while (n3 > 0) {
                    if (bl) {
                        stringArray3 = stringArray2;
                    }
                    if (debug.booleanValue()) {
                        System.out.println(stringArray3[0] + " " + stringArray3[1]);
                    }
                    if (stringArray3[0].equals("DEFAULT_DELAY") || stringArray3[0].equals("DEFAULTDELAY")) {
                        n2 = Integer.parseInt(stringArray3[1].trim());
                        n = 1;
                    } else if (stringArray3[0].equals("DELAY")) {
                        n4 = Integer.parseInt(stringArray3[1].trim());
                        while (n4 > 0) {
                            arrayList.add((byte)0);
                            if (n4 > 255) {
                                arrayList.add((byte)-1);
                                n4 -= 255;
                                continue;
                            }
                            arrayList.add((byte)n4);
                            n4 = 0;
                        }
                        n = 1;
                    } else if (stringArray3[0].equals("STRING")) {
                        for (n4 = 0; n4 < stringArray3[1].length(); ++n4) {
                            char c = stringArray3[1].charAt(n4);
                            Encoder.addBytes(arrayList, Encoder.charToBytes(c));
                        }
                    } else if (stringArray3[0].equals("CONTROL") || stringArray3[0].equals("CTRL")) {
                        if (stringArray3.length != 1) {
                            arrayList.add(Encoder.strInstrToByte(stringArray3[1]));
                            arrayList.add(Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_CTRL")));
                        } else {
                            arrayList.add(Encoder.strToByte(keyboardProps.getProperty("KEY_LEFT_CTRL")));
                            arrayList.add((byte)0);
                        }
                    } else if (stringArray3[0].equals("ALT")) {
                        if (stringArray3.length != 1) {
                            arrayList.add(Encoder.strInstrToByte(stringArray3[1]));
                            arrayList.add(Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_ALT")));
                        } else {
                            arrayList.add(Encoder.strToByte(keyboardProps.getProperty("KEY_LEFT_ALT")));
                            arrayList.add((byte)0);
                        }
                    } else if (stringArray3[0].equals("SHIFT")) {
                        if (stringArray3.length != 1) {
                            arrayList.add(Encoder.strInstrToByte(stringArray3[1]));
                            arrayList.add(Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_SHIFT")));
                        } else {
                            arrayList.add(Encoder.strToByte(keyboardProps.getProperty("KEY_LEFT_SHIFT")));
                            arrayList.add((byte)0);
                        }
                    } else if (stringArray3[0].equals("CTRL-ALT")) {
                        if (stringArray3.length == 1) continue;
                        arrayList.add(Encoder.strInstrToByte(stringArray3[1]));
                        arrayList.add((byte)(Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_CTRL")) | Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_ALT"))));
                    } else if (stringArray3[0].equals("CTRL-SHIFT")) {
                        if (stringArray3.length == 1) continue;
                        arrayList.add(Encoder.strInstrToByte(stringArray3[1]));
                        arrayList.add((byte)(Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_CTRL")) | Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_SHIFT"))));
                    } else if (stringArray3[0].equals("COMMAND-OPTION")) {
                        if (stringArray3.length == 1) continue;
                        arrayList.add(Encoder.strInstrToByte(stringArray3[1]));
                        arrayList.add((byte)(Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_KEY_LEFT_GUI")) | Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_ALT"))));
                    } else if (stringArray3[0].equals("ALT-SHIFT")) {
                        if (stringArray3.length != 1) {
                            arrayList.add(Encoder.strInstrToByte(stringArray3[1]));
                            arrayList.add((byte)(Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_LEFT_ALT")) | Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_SHIFT"))));
                        } else {
                            arrayList.add(Encoder.strToByte(keyboardProps.getProperty("KEY_LEFT_ALT")));
                            arrayList.add((byte)(Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_LEFT_ALT")) | Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_SHIFT"))));
                        }
                    } else if (stringArray3[0].equals("ALT-TAB")) {
                        if (stringArray3.length == 1) {
                            arrayList.add(Encoder.strToByte(keyboardProps.getProperty("KEY_TAB")));
                            arrayList.add(Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_LEFT_ALT")));
                        }
                    } else {
                        if (stringArray3[0].equals("REM")) {
                            n = 1;
                            continue;
                        }
                        if (stringArray3[0].equals("WINDOWS") || stringArray3[0].equals("GUI")) {
                            if (stringArray3.length == 1) {
                                arrayList.add(Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_LEFT_GUI")));
                                arrayList.add((byte)0);
                            } else {
                                arrayList.add(Encoder.strInstrToByte(stringArray3[1]));
                                arrayList.add(Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_LEFT_GUI")));
                            }
                        } else if (stringArray3[0].equals("COMMAND")) {
                            if (stringArray3.length == 1) {
                                arrayList.add(Encoder.strToByte(keyboardProps.getProperty("KEY_COMMAND")));
                                arrayList.add((byte)0);
                            } else {
                                arrayList.add(Encoder.strInstrToByte(stringArray3[1]));
                                arrayList.add(Encoder.strToByte(keyboardProps.getProperty("MODIFIERKEY_LEFT_GUI")));
                            }
                        } else {
                            arrayList.add(Encoder.strInstrToByte(stringArray3[0]));
                            arrayList.add((byte)0);
                        }
                    }
                    --n3;
                }
                if (!(n == 0 & n2 > 0)) continue;
                n4 = n2;
                while (n4 > 0) {
                    arrayList.add((byte)0);
                    if (n4 > 255) {
                        arrayList.add((byte)-1);
                        n4 -= 255;
                        continue;
                    }
                    arrayList.add((byte)n4);
                    n4 = 0;
                }
                continue;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error on Line: " + (i + 1));
                exception.printStackTrace();
            }
        }
        byte[] byArray = new byte[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            byArray[n] = (Byte)arrayList.get(n);
        }
        try {
            File file = new File(string2);
            object = new FileOutputStream(file);
            ((FileOutputStream)object).write(byArray);
            ((OutputStream)object).flush();
            ((FileOutputStream)object).close();
            System.out.println("DuckyScript Complete.....\t[ OK ]\n");
        }
        catch (Exception exception) {
            System.out.print("Failed to write hex file!");
        }
    }

    private static void addBytes(List<Byte> list, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            list.add(byArray[i]);
        }
        if (byArray.length % 2 != 0) {
            list.add((byte)0);
        }
    }

    private static byte[] charToBytes(char c) {
        return Encoder.codeToBytes(Encoder.charToCode(c));
    }

    private static String charToCode(char c) {
        String string = c < '\u0080' ? "ASCII_" + Integer.toHexString(c).toUpperCase() : (c < '\u0100' ? "ISO_8859_1_" + Integer.toHexString(c).toUpperCase() : "UNICODE_" + Integer.toHexString(c).toUpperCase());
        return string;
    }

    private static byte[] codeToBytes(String string) {
        if (layoutProps.getProperty(string) != null) {
            String[] stringArray = layoutProps.getProperty(string).split(",");
            byte[] byArray = new byte[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i].trim();
                if (keyboardProps.getProperty(string2) != null) {
                    byArray[i] = Encoder.strToByte(keyboardProps.getProperty(string2).trim());
                    continue;
                }
                if (layoutProps.getProperty(string2) != null) {
                    byArray[i] = Encoder.strToByte(layoutProps.getProperty(string2).trim());
                    continue;
                }
                System.out.println("Key not found:" + string2);
                byArray[i] = 0;
            }
            return byArray;
        }
        System.out.println("Char not found:" + string);
        byte[] byArray = new byte[]{0};
        return byArray;
    }

    private static byte strToByte(String string) {
        if (string.startsWith("0x")) {
            return (byte)Integer.parseInt(string.substring(2), 16);
        }
        return (byte)Integer.parseInt(string);
    }

    private static byte strInstrToByte(String string) {
        string = string.trim();
        if (keyboardProps.getProperty("KEY_" + string) != null) {
            return Encoder.strToByte(keyboardProps.getProperty("KEY_" + string));
        }
        if (string.equals("ESCAPE")) {
            return Encoder.strInstrToByte("ESC");
        }
        if (string.equals("DEL")) {
            return Encoder.strInstrToByte("DELETE");
        }
        if (string.equals("BREAK")) {
            return Encoder.strInstrToByte("PAUSE");
        }
        if (string.equals("CONTROL")) {
            return Encoder.strInstrToByte("CTRL");
        }
        if (string.equals("DOWNARROW")) {
            return Encoder.strInstrToByte("DOWN");
        }
        if (string.equals("UPARROW")) {
            return Encoder.strInstrToByte("UP");
        }
        if (string.equals("LEFTARROW")) {
            return Encoder.strInstrToByte("LEFT");
        }
        if (string.equals("RIGHTARROW")) {
            return Encoder.strInstrToByte("RIGHT");
        }
        if (string.equals("MENU")) {
            return Encoder.strInstrToByte("APP");
        }
        if (string.equals("WINDOWS")) {
            return Encoder.strInstrToByte("GUI");
        }
        if (string.equals("PLAY") || string.equals("PAUSE")) {
            return Encoder.strInstrToByte("MEDIA_PLAY_PAUSE");
        }
        if (string.equals("STOP")) {
            return Encoder.strInstrToByte("MEDIA_STOP");
        }
        if (string.equals("MUTE")) {
            return Encoder.strInstrToByte("MEDIA_MUTE");
        }
        if (string.equals("VOLUMEUP")) {
            return Encoder.strInstrToByte("MEDIA_VOLUME_INC");
        }
        if (string.equals("VOLUMEDOWN")) {
            return Encoder.strInstrToByte("MEDIA_VOLUME_DEC");
        }
        if (string.equals("SCROLLLOCK")) {
            return Encoder.strInstrToByte("SCROLL_LOCK");
        }
        if (string.equals("NUMLOCK")) {
            return Encoder.strInstrToByte("NUM_LOCK");
        }
        if (string.equals("CAPSLOCK")) {
            return Encoder.strInstrToByte("CAPS_LOCK");
        }
        return Encoder.charToBytes(string.charAt(0))[0];
    }
}

