/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.nano.android;

import android.os.Parcel;
import android.util.Log;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.protobuf.nano.MessageNano;

final class ParcelingUtil {
    private static final String TAG = "ParcelingUtil";

    ParcelingUtil() {
    }

    static <T extends MessageNano> T createFromParcel(Parcel in) {
        String className = in.readString();
        byte[] data = in.createByteArray();
        MessageNano proto = null;
        try {
            Class<?> clazz = Class.forName(className);
            Object instance = clazz.newInstance();
            proto = (MessageNano)instance;
            MessageNano.mergeFrom(proto, data);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)"Exception trying to create proto from parcel", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"Exception trying to create proto from parcel", (Throwable)e);
        }
        catch (InstantiationException e) {
            Log.e((String)TAG, (String)"Exception trying to create proto from parcel", (Throwable)e);
        }
        catch (InvalidProtocolBufferNanoException e) {
            Log.e((String)TAG, (String)"Exception trying to create proto from parcel", (Throwable)e);
        }
        return (T)proto;
    }

    static <T extends MessageNano> void writeToParcel(Class<T> clazz, MessageNano message, Parcel out) {
        out.writeString(clazz.getName());
        out.writeByteArray(MessageNano.toByteArray(message));
    }
}

