/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard.proto;

import com.google.protobuf.nano.CodedInputByteBufferNano;
import com.google.protobuf.nano.CodedOutputByteBufferNano;
import com.google.protobuf.nano.InternalNano;
import com.google.protobuf.nano.InvalidProtocolBufferNanoException;
import com.google.protobuf.nano.MessageNano;
import com.google.protobuf.nano.WireFormatNano;
import java.io.IOException;

public interface CardboardDevice {

    public static final class DeviceParams
    extends MessageNano {
        private static volatile DeviceParams[] _emptyArray;
        private int bitField0_;
        private String vendor_;
        private String model_;
        private float screenToLensDistance_;
        private float interLensDistance_;
        public float[] leftEyeFieldOfViewAngles;
        private float trayBottomToLensHeight_;
        public float[] distortionCoefficients;
        private boolean hasMagnet_;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DeviceParams[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new DeviceParams[0];
                    }
                }
            }
            return _emptyArray;
        }

        public String getVendor() {
            return this.vendor_;
        }

        public DeviceParams setVendor(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.vendor_ = value;
            this.bitField0_ |= 1;
            return this;
        }

        public boolean hasVendor() {
            return (this.bitField0_ & 1) != 0;
        }

        public DeviceParams clearVendor() {
            this.vendor_ = "";
            this.bitField0_ &= 0xFFFFFFFE;
            return this;
        }

        public String getModel() {
            return this.model_;
        }

        public DeviceParams setModel(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.model_ = value;
            this.bitField0_ |= 2;
            return this;
        }

        public boolean hasModel() {
            return (this.bitField0_ & 2) != 0;
        }

        public DeviceParams clearModel() {
            this.model_ = "";
            this.bitField0_ &= 0xFFFFFFFD;
            return this;
        }

        public float getScreenToLensDistance() {
            return this.screenToLensDistance_;
        }

        public DeviceParams setScreenToLensDistance(float value) {
            this.screenToLensDistance_ = value;
            this.bitField0_ |= 4;
            return this;
        }

        public boolean hasScreenToLensDistance() {
            return (this.bitField0_ & 4) != 0;
        }

        public DeviceParams clearScreenToLensDistance() {
            this.screenToLensDistance_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFFB;
            return this;
        }

        public float getInterLensDistance() {
            return this.interLensDistance_;
        }

        public DeviceParams setInterLensDistance(float value) {
            this.interLensDistance_ = value;
            this.bitField0_ |= 8;
            return this;
        }

        public boolean hasInterLensDistance() {
            return (this.bitField0_ & 8) != 0;
        }

        public DeviceParams clearInterLensDistance() {
            this.interLensDistance_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFF7;
            return this;
        }

        public float getTrayBottomToLensHeight() {
            return this.trayBottomToLensHeight_;
        }

        public DeviceParams setTrayBottomToLensHeight(float value) {
            this.trayBottomToLensHeight_ = value;
            this.bitField0_ |= 0x10;
            return this;
        }

        public boolean hasTrayBottomToLensHeight() {
            return (this.bitField0_ & 0x10) != 0;
        }

        public DeviceParams clearTrayBottomToLensHeight() {
            this.trayBottomToLensHeight_ = 0.0f;
            this.bitField0_ &= 0xFFFFFFEF;
            return this;
        }

        public boolean getHasMagnet() {
            return this.hasMagnet_;
        }

        public DeviceParams setHasMagnet(boolean value) {
            this.hasMagnet_ = value;
            this.bitField0_ |= 0x20;
            return this;
        }

        public boolean hasHasMagnet() {
            return (this.bitField0_ & 0x20) != 0;
        }

        public DeviceParams clearHasMagnet() {
            this.hasMagnet_ = false;
            this.bitField0_ &= 0xFFFFFFDF;
            return this;
        }

        public DeviceParams() {
            this.clear();
        }

        public DeviceParams clear() {
            this.bitField0_ = 0;
            this.vendor_ = "";
            this.model_ = "";
            this.screenToLensDistance_ = 0.0f;
            this.interLensDistance_ = 0.0f;
            this.leftEyeFieldOfViewAngles = WireFormatNano.EMPTY_FLOAT_ARRAY;
            this.trayBottomToLensHeight_ = 0.0f;
            this.distortionCoefficients = WireFormatNano.EMPTY_FLOAT_ARRAY;
            this.hasMagnet_ = false;
            this.cachedSize = -1;
            return this;
        }

        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            int i;
            int dataSize;
            if ((this.bitField0_ & 1) != 0) {
                output.writeString(1, this.vendor_);
            }
            if ((this.bitField0_ & 2) != 0) {
                output.writeString(2, this.model_);
            }
            if ((this.bitField0_ & 4) != 0) {
                output.writeFloat(3, this.screenToLensDistance_);
            }
            if ((this.bitField0_ & 8) != 0) {
                output.writeFloat(4, this.interLensDistance_);
            }
            if (this.leftEyeFieldOfViewAngles != null && this.leftEyeFieldOfViewAngles.length > 0) {
                dataSize = 4 * this.leftEyeFieldOfViewAngles.length;
                output.writeRawVarint32(42);
                output.writeRawVarint32(dataSize);
                for (i = 0; i < this.leftEyeFieldOfViewAngles.length; ++i) {
                    output.writeFloatNoTag(this.leftEyeFieldOfViewAngles[i]);
                }
            }
            if ((this.bitField0_ & 0x10) != 0) {
                output.writeFloat(6, this.trayBottomToLensHeight_);
            }
            if (this.distortionCoefficients != null && this.distortionCoefficients.length > 0) {
                dataSize = 4 * this.distortionCoefficients.length;
                output.writeRawVarint32(58);
                output.writeRawVarint32(dataSize);
                for (i = 0; i < this.distortionCoefficients.length; ++i) {
                    output.writeFloatNoTag(this.distortionCoefficients[i]);
                }
            }
            if ((this.bitField0_ & 0x20) != 0) {
                output.writeBool(10, this.hasMagnet_);
            }
            super.writeTo(output);
        }

        protected int computeSerializedSize() {
            int dataSize;
            int size = super.computeSerializedSize();
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputByteBufferNano.computeStringSize((int)1, (String)this.vendor_);
            }
            if ((this.bitField0_ & 2) != 0) {
                size += CodedOutputByteBufferNano.computeStringSize((int)2, (String)this.model_);
            }
            if ((this.bitField0_ & 4) != 0) {
                size += CodedOutputByteBufferNano.computeFloatSize((int)3, (float)this.screenToLensDistance_);
            }
            if ((this.bitField0_ & 8) != 0) {
                size += CodedOutputByteBufferNano.computeFloatSize((int)4, (float)this.interLensDistance_);
            }
            if (this.leftEyeFieldOfViewAngles != null && this.leftEyeFieldOfViewAngles.length > 0) {
                dataSize = 4 * this.leftEyeFieldOfViewAngles.length;
                size += dataSize;
                ++size;
                size += CodedOutputByteBufferNano.computeRawVarint32Size((int)dataSize);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                size += CodedOutputByteBufferNano.computeFloatSize((int)6, (float)this.trayBottomToLensHeight_);
            }
            if (this.distortionCoefficients != null && this.distortionCoefficients.length > 0) {
                dataSize = 4 * this.distortionCoefficients.length;
                size += dataSize;
                ++size;
                size += CodedOutputByteBufferNano.computeRawVarint32Size((int)dataSize);
            }
            if ((this.bitField0_ & 0x20) != 0) {
                size += CodedOutputByteBufferNano.computeBoolSize((int)10, (boolean)this.hasMagnet_);
            }
            return size;
        }

        public DeviceParams mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block13: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField((CodedInputByteBufferNano)input, (int)tag)) continue block13;
                        return this;
                    }
                    case 10: {
                        this.vendor_ = input.readString();
                        this.bitField0_ |= 1;
                        continue block13;
                    }
                    case 18: {
                        this.model_ = input.readString();
                        this.bitField0_ |= 2;
                        continue block13;
                    }
                    case 29: {
                        this.screenToLensDistance_ = input.readFloat();
                        this.bitField0_ |= 4;
                        continue block13;
                    }
                    case 37: {
                        this.interLensDistance_ = input.readFloat();
                        this.bitField0_ |= 8;
                        continue block13;
                    }
                    case 45: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)input, (int)45);
                        int i = this.leftEyeFieldOfViewAngles == null ? 0 : this.leftEyeFieldOfViewAngles.length;
                        float[] newArray = new float[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.leftEyeFieldOfViewAngles, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readFloat();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readFloat();
                        this.leftEyeFieldOfViewAngles = newArray;
                        continue block13;
                    }
                    case 42: {
                        int length = input.readRawVarint32();
                        int limit = input.pushLimit(length);
                        int arrayLength = length / 4;
                        int i = this.leftEyeFieldOfViewAngles == null ? 0 : this.leftEyeFieldOfViewAngles.length;
                        float[] newArray = new float[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.leftEyeFieldOfViewAngles, 0, newArray, 0, i);
                        }
                        while (i < newArray.length) {
                            newArray[i] = input.readFloat();
                            ++i;
                        }
                        this.leftEyeFieldOfViewAngles = newArray;
                        input.popLimit(limit);
                        continue block13;
                    }
                    case 53: {
                        this.trayBottomToLensHeight_ = input.readFloat();
                        this.bitField0_ |= 0x10;
                        continue block13;
                    }
                    case 61: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength((CodedInputByteBufferNano)input, (int)61);
                        int i = this.distortionCoefficients == null ? 0 : this.distortionCoefficients.length;
                        float[] newArray = new float[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.distortionCoefficients, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readFloat();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readFloat();
                        this.distortionCoefficients = newArray;
                        continue block13;
                    }
                    case 58: {
                        int length = input.readRawVarint32();
                        int limit = input.pushLimit(length);
                        int arrayLength = length / 4;
                        int i = this.distortionCoefficients == null ? 0 : this.distortionCoefficients.length;
                        float[] newArray = new float[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.distortionCoefficients, 0, newArray, 0, i);
                        }
                        while (i < newArray.length) {
                            newArray[i] = input.readFloat();
                            ++i;
                        }
                        this.distortionCoefficients = newArray;
                        input.popLimit(limit);
                        continue block13;
                    }
                    case 80: 
                }
                this.hasMagnet_ = input.readBool();
                this.bitField0_ |= 0x20;
            }
        }

        public static DeviceParams parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return (DeviceParams)MessageNano.mergeFrom((MessageNano)new DeviceParams(), (byte[])data);
        }

        public static DeviceParams parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new DeviceParams().mergeFrom(input);
        }
    }
}

