/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard.sensors;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.google.vrtoolkit.cardboard.sensors.SensorEventProvider;
import java.util.ArrayList;
import java.util.Iterator;

public class DeviceSensorLooper
implements SensorEventProvider {
    private boolean mIsRunning;
    private SensorManager mSensorManager;
    private Looper mSensorLooper;
    private SensorEventListener mSensorEventListener;
    private final ArrayList<SensorEventListener> mRegisteredListeners = new ArrayList();
    private static final int[] INPUT_SENSORS = new int[]{1, 4};

    public DeviceSensorLooper(SensorManager sensorManager) {
        this.mSensorManager = sensorManager;
    }

    @Override
    public void start() {
        if (this.mIsRunning) {
            return;
        }
        this.mSensorEventListener = new SensorEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onSensorChanged(SensorEvent event) {
                Iterator i$ = DeviceSensorLooper.this.mRegisteredListeners.iterator();
                while (i$.hasNext()) {
                    SensorEventListener listener;
                    SensorEventListener sensorEventListener = listener = (SensorEventListener)i$.next();
                    synchronized (sensorEventListener) {
                        listener.onSensorChanged(event);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onAccuracyChanged(Sensor sensor, int accuracy) {
                Iterator i$ = DeviceSensorLooper.this.mRegisteredListeners.iterator();
                while (i$.hasNext()) {
                    SensorEventListener listener;
                    SensorEventListener sensorEventListener = listener = (SensorEventListener)i$.next();
                    synchronized (sensorEventListener) {
                        listener.onAccuracyChanged(sensor, accuracy);
                    }
                }
            }
        };
        HandlerThread sensorThread = new HandlerThread("sensor"){

            protected void onLooperPrepared() {
                Handler handler = new Handler(Looper.myLooper());
                for (int sensorType : INPUT_SENSORS) {
                    Sensor sensor = DeviceSensorLooper.this.mSensorManager.getDefaultSensor(sensorType);
                    DeviceSensorLooper.this.mSensorManager.registerListener(DeviceSensorLooper.this.mSensorEventListener, sensor, 0, handler);
                }
            }
        };
        sensorThread.start();
        this.mSensorLooper = sensorThread.getLooper();
        this.mIsRunning = true;
    }

    @Override
    public void stop() {
        if (!this.mIsRunning) {
            return;
        }
        this.mSensorManager.unregisterListener(this.mSensorEventListener);
        this.mSensorEventListener = null;
        this.mSensorLooper.quit();
        this.mSensorLooper = null;
        this.mIsRunning = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerListener(SensorEventListener listener) {
        ArrayList<SensorEventListener> arrayList = this.mRegisteredListeners;
        synchronized (arrayList) {
            this.mRegisteredListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterListener(SensorEventListener listener) {
        ArrayList<SensorEventListener> arrayList = this.mRegisteredListeners;
        synchronized (arrayList) {
            this.mRegisteredListeners.remove(listener);
        }
    }
}

