/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard.sensors;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.opengl.Matrix;
import android.view.Display;
import android.view.WindowManager;
import com.google.vrtoolkit.cardboard.sensors.Clock;
import com.google.vrtoolkit.cardboard.sensors.DeviceSensorLooper;
import com.google.vrtoolkit.cardboard.sensors.SensorEventProvider;
import com.google.vrtoolkit.cardboard.sensors.SystemClock;
import com.google.vrtoolkit.cardboard.sensors.internal.OrientationEKF;
import com.google.vrtoolkit.cardboard.sensors.internal.Vector3d;
import java.util.concurrent.TimeUnit;

public class HeadTracker
implements SensorEventListener {
    private static final float DEFAULT_NECK_HORIZONTAL_OFFSET = 0.08f;
    private static final float DEFAULT_NECK_VERTICAL_OFFSET = 0.075f;
    private static final boolean DEFAULT_NECK_MODEL_ENABLED = false;
    private final Display mDisplay;
    private final float[] mEkfToHeadTracker = new float[16];
    private final float[] mSensorToDisplay = new float[16];
    private float mDisplayRotation = Float.NaN;
    private final float[] mNeckModelTranslation = new float[16];
    private final float[] mTmpHeadView = new float[16];
    private final float[] mTmpHeadView2 = new float[16];
    private boolean mNeckModelEnabled = false;
    private volatile boolean mTracking;
    private OrientationEKF mTracker;
    private SensorEventProvider mSensorEventProvider;
    private Clock mClock;
    private long mLatestGyroEventClockTimeNs;
    private final Vector3d mGyroBias = new Vector3d();
    private final Vector3d mLatestGyro = new Vector3d();
    private final Vector3d mLatestAcc = new Vector3d();

    public static HeadTracker createFromContext(Context context) {
        SensorManager sensorManager = (SensorManager)context.getSystemService("sensor");
        Display display = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        return new HeadTracker(new DeviceSensorLooper(sensorManager), new SystemClock(), display);
    }

    public HeadTracker(SensorEventProvider sensorEventProvider, Clock clock, Display display) {
        this.mClock = clock;
        this.mSensorEventProvider = sensorEventProvider;
        this.mTracker = new OrientationEKF();
        this.mDisplay = display;
        Matrix.setIdentityM((float[])this.mNeckModelTranslation, (int)0);
        Matrix.translateM((float[])this.mNeckModelTranslation, (int)0, (float)0.0f, (float)-0.075f, (float)0.08f);
    }

    public void onSensorChanged(SensorEvent event) {
        if (event.sensor.getType() == 1) {
            this.mLatestAcc.set(event.values[0], event.values[1], event.values[2]);
            this.mTracker.processAcc(this.mLatestAcc, event.timestamp);
        } else if (event.sensor.getType() == 4) {
            this.mLatestGyroEventClockTimeNs = this.mClock.nanoTime();
            this.mLatestGyro.set(event.values[0], event.values[1], event.values[2]);
            Vector3d.sub(this.mLatestGyro, this.mGyroBias, this.mLatestGyro);
            this.mTracker.processGyro(this.mLatestGyro, event.timestamp);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void startTracking() {
        if (this.mTracking) {
            return;
        }
        this.mTracker.reset();
        this.mSensorEventProvider.registerListener(this);
        this.mSensorEventProvider.start();
        this.mTracking = true;
    }

    public void stopTracking() {
        if (!this.mTracking) {
            return;
        }
        this.mSensorEventProvider.unregisterListener(this);
        this.mSensorEventProvider.stop();
        this.mTracking = false;
    }

    public void setGyroBias(float[] gyroBias) {
        if (gyroBias == null) {
            this.mGyroBias.setZero();
            return;
        }
        if (gyroBias.length != 3) {
            throw new IllegalArgumentException("Gyro bias should be an array of 3 values");
        }
        this.mGyroBias.set(gyroBias[0], gyroBias[1], gyroBias[2]);
    }

    public void setNeckModelEnabled(boolean enabled) {
        this.mNeckModelEnabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getLastHeadView(float[] headView, int offset) {
        if (offset + 16 > headView.length) {
            throw new IllegalArgumentException("Not enough space to write the result");
        }
        float rotation = 0.0f;
        switch (this.mDisplay.getRotation()) {
            case 0: {
                rotation = 0.0f;
                break;
            }
            case 1: {
                rotation = 90.0f;
                break;
            }
            case 2: {
                rotation = 180.0f;
                break;
            }
            case 3: {
                rotation = 270.0f;
            }
        }
        if (rotation != this.mDisplayRotation) {
            this.mDisplayRotation = rotation;
            Matrix.setRotateEulerM((float[])this.mSensorToDisplay, (int)0, (float)0.0f, (float)0.0f, (float)(-rotation));
            Matrix.setRotateEulerM((float[])this.mEkfToHeadTracker, (int)0, (float)-90.0f, (float)0.0f, (float)rotation);
        }
        OrientationEKF orientationEKF = this.mTracker;
        synchronized (orientationEKF) {
            double secondsSinceLastGyroEvent = TimeUnit.NANOSECONDS.toSeconds(this.mClock.nanoTime() - this.mLatestGyroEventClockTimeNs);
            double secondsToPredictForward = secondsSinceLastGyroEvent + 0.03333333333333333;
            double[] mat = this.mTracker.getPredictedGLMatrix(secondsToPredictForward);
            for (int i = 0; i < headView.length; ++i) {
                this.mTmpHeadView[i] = (float)mat[i];
            }
        }
        Matrix.multiplyMM((float[])this.mTmpHeadView2, (int)0, (float[])this.mSensorToDisplay, (int)0, (float[])this.mTmpHeadView, (int)0);
        Matrix.multiplyMM((float[])headView, (int)offset, (float[])this.mTmpHeadView2, (int)0, (float[])this.mEkfToHeadTracker, (int)0);
        if (this.mNeckModelEnabled) {
            Matrix.multiplyMM((float[])this.mTmpHeadView, (int)0, (float[])this.mNeckModelTranslation, (int)0, (float[])headView, (int)offset);
            Matrix.translateM((float[])headView, (int)offset, (float[])this.mTmpHeadView, (int)0, (float)0.0f, (float)0.075f, (float)0.0f);
        }
    }
}

