/*
 * Decompiled with CFR 0.152.
 */
package com.google.vrtoolkit.cardboard.sensors;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import java.util.ArrayList;
import java.util.Arrays;

public class MagnetSensor {
    private static final String HTC_ONE_MODEL = "HTC One";
    private TriggerDetector mDetector;
    private Thread mDetectorThread;

    public MagnetSensor(Context context) {
        this.mDetector = HTC_ONE_MODEL.equals(Build.MODEL) ? new VectorTriggerDetector(context) : new ThresholdTriggerDetector(context);
    }

    public void start() {
        this.mDetectorThread = new Thread(this.mDetector);
        this.mDetectorThread.start();
    }

    public void stop() {
        if (this.mDetectorThread != null) {
            this.mDetectorThread.interrupt();
            this.mDetector.stop();
        }
    }

    public void setOnCardboardTriggerListener(OnCardboardTriggerListener listener) {
        this.mDetector.setOnCardboardTriggerListener(listener, new Handler());
    }

    private static class VectorTriggerDetector
    extends TriggerDetector {
        private static final String TAG = "ThresholdTriggerDetector";
        private static final long NS_REFRESH_TIME = 350000000L;
        private static final long NS_THROWAWAY_SIZE = 500000000L;
        private static final long NS_WAIT_SIZE = 100000000L;
        private long mLastFiring = 0L;
        private static int mXThreshold;
        private static int mYThreshold;
        private static int mZThreshold;
        private ArrayList<float[]> mSensorData = new ArrayList();
        private ArrayList<Long> mSensorTimes = new ArrayList();

        public VectorTriggerDetector(Context context) {
            super(context);
            mXThreshold = -3;
            mYThreshold = 15;
            mZThreshold = 6;
        }

        public VectorTriggerDetector(Context context, int xThreshold, int yThreshold, int zThreshold) {
            super(context);
            mXThreshold = xThreshold;
            mYThreshold = yThreshold;
            mZThreshold = zThreshold;
        }

        private void addData(float[] values, long time) {
            this.mSensorData.add(values);
            this.mSensorTimes.add(time);
            while (this.mSensorTimes.get(0) < time - 500000000L) {
                this.mSensorData.remove(0);
                this.mSensorTimes.remove(0);
            }
            this.evaluateModel(time);
        }

        private void evaluateModel(long time) {
            if (time - this.mLastFiring < 350000000L || this.mSensorData.size() < 2) {
                return;
            }
            int baseIndex = 0;
            for (int i = 1; i < this.mSensorTimes.size(); ++i) {
                if (time - this.mSensorTimes.get(i) >= 100000000L) continue;
                baseIndex = i;
                break;
            }
            float[] oldValues = this.mSensorData.get(baseIndex);
            float[] currentValues = this.mSensorData.get(this.mSensorData.size() - 1);
            if (currentValues[0] - oldValues[0] < (float)mXThreshold && currentValues[1] - oldValues[1] > (float)mYThreshold && currentValues[2] - oldValues[2] > (float)mZThreshold) {
                this.mLastFiring = time;
                this.handleButtonPressed();
            }
        }

        @Override
        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.equals(this.mMagnetometer)) {
                float[] values = event.values;
                if (values[0] == 0.0f && values[1] == 0.0f && values[2] == 0.0f) {
                    return;
                }
                this.addData((float[])event.values.clone(), event.timestamp);
            }
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }

    private static class ThresholdTriggerDetector
    extends TriggerDetector {
        private static final String TAG = "ThresholdTriggerDetector";
        private static final long NS_SEGMENT_SIZE = 200000000L;
        private static final long NS_WINDOW_SIZE = 400000000L;
        private static final long NS_WAIT_TIME = 350000000L;
        private long mLastFiring = 0L;
        private static int mT1 = 30;
        private static int mT2 = 130;
        private ArrayList<float[]> mSensorData = new ArrayList();
        private ArrayList<Long> mSensorTimes = new ArrayList();

        public ThresholdTriggerDetector(Context context) {
            super(context);
        }

        public ThresholdTriggerDetector(Context context, int t1, int t2) {
            super(context);
            mT1 = t1;
            mT2 = t2;
        }

        private void addData(float[] values, long time) {
            this.mSensorData.add(values);
            this.mSensorTimes.add(time);
            while (this.mSensorTimes.get(0) < time - 400000000L) {
                this.mSensorData.remove(0);
                this.mSensorTimes.remove(0);
            }
            this.evaluateModel(time);
        }

        private void evaluateModel(long time) {
            if (time - this.mLastFiring < 350000000L || this.mSensorData.size() < 2) {
                return;
            }
            float[] baseline = this.mSensorData.get(this.mSensorData.size() - 1);
            int startSecondSegment = 0;
            for (int i = 0; i < this.mSensorTimes.size(); ++i) {
                if (time - this.mSensorTimes.get(i) >= 200000000L) continue;
                startSecondSegment = i;
                break;
            }
            float[] offsets = new float[this.mSensorData.size()];
            this.computeOffsets(offsets, baseline);
            float min1 = this.computeMinimum(Arrays.copyOfRange(offsets, 0, startSecondSegment));
            float max2 = this.computeMaximum(Arrays.copyOfRange(offsets, startSecondSegment, this.mSensorData.size()));
            if (min1 < (float)mT1 && max2 > (float)mT2) {
                this.mLastFiring = time;
                this.handleButtonPressed();
            }
        }

        private void computeOffsets(float[] offsets, float[] baseline) {
            for (int i = 0; i < this.mSensorData.size(); ++i) {
                float magnitude;
                float[] point = this.mSensorData.get(i);
                float[] o = new float[]{point[0] - baseline[0], point[1] - baseline[1], point[2] - baseline[2]};
                offsets[i] = magnitude = (float)Math.sqrt(o[0] * o[0] + o[1] * o[1] + o[2] * o[2]);
            }
        }

        private float computeMaximum(float[] offsets) {
            float max = Float.NEGATIVE_INFINITY;
            for (float o : offsets) {
                max = Math.max(o, max);
            }
            return max;
        }

        private float computeMinimum(float[] offsets) {
            float min = Float.POSITIVE_INFINITY;
            for (float o : offsets) {
                min = Math.min(o, min);
            }
            return min;
        }

        @Override
        public void onSensorChanged(SensorEvent event) {
            if (event.sensor.equals(this.mMagnetometer)) {
                float[] values = event.values;
                if (values[0] == 0.0f && values[1] == 0.0f && values[2] == 0.0f) {
                    return;
                }
                this.addData((float[])event.values.clone(), event.timestamp);
            }
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }

    private static abstract class TriggerDetector
    implements Runnable,
    SensorEventListener {
        protected static final String TAG = "TriggerDetector";
        protected SensorManager mSensorManager;
        protected Sensor mMagnetometer;
        protected OnCardboardTriggerListener mListener;
        protected Handler mHandler;

        public TriggerDetector(Context context) {
            this.mSensorManager = (SensorManager)context.getSystemService("sensor");
            this.mMagnetometer = this.mSensorManager.getDefaultSensor(2);
        }

        public synchronized void setOnCardboardTriggerListener(OnCardboardTriggerListener listener, Handler handler) {
            this.mListener = listener;
            this.mHandler = handler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleButtonPressed() {
            TriggerDetector triggerDetector = this;
            synchronized (triggerDetector) {
                if (this.mListener != null) {
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (TriggerDetector.this.mListener != null) {
                                TriggerDetector.this.mListener.onCardboardTrigger();
                            }
                        }
                    });
                }
            }
        }

        @Override
        public void run() {
            Looper.prepare();
            this.mSensorManager.registerListener((SensorEventListener)this, this.mMagnetometer, 0);
            Looper.loop();
        }

        public void stop() {
            this.mSensorManager.unregisterListener((SensorEventListener)this);
        }

        public void onSensorChanged(SensorEvent event) {
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }

    public static interface OnCardboardTriggerListener {
        public void onCardboardTrigger();
    }
}

