/*
*  Copyright (C) 2002-2010  The DOSBox Team
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/* $Id: DirecuIO.cpp,v 1.00 2015-10-13 17:49:18 as/c't $ */




#include "dosbox.h"
#include "inout.h"
#include "setup.h"

#if C_DIRECTIO

Bitu offset;
static void DirectIO_writeport(Bitu port, Bitu val, Bitu iolen) {
	if (iolen == 1)
	{
		__outbyte(port+offset, val);
	}
}

static Bitu DirectIO_readport(Bitu port, Bitu iolen) {
	if (iolen == 1)
	{
		//return 0x77;
		return __inbyte(port+offset);
	}
	return 0;
}


class DirectIO :public Module_base{

private:
	IO_ReadHandleObject ReadHandler[20];
	IO_WriteHandleObject WriteHandler[20];
public:
	DirectIO(Section* configuration) :Module_base(configuration){
		Section_prop * section = static_cast<Section_prop *>(configuration);
		//if (!section->Get_bool("directio")) return;

		
		Bitu from = section->Get_hex("from");
		Bitu size = section->Get_hex("size");
		offset = section->Get_hex("offset");
#if _DEBUG
		printf("DirectIO Init");
		printf(" from:%x  offset:%x target:%x size:%x \n", from, offset, from + offset, size);
#endif
		from += offset;

		if ((from < 0x100) || (size == 0)) return;     //Exclude Porty < 0x100 
		if ((from >= 0xCF0) && (from < 0xCFF)) return; //Exclude PCI-Addresses
		if (size > 0x20) size = 0x20;
		
			WriteHandler[0].Install(from, DirectIO_writeport, IO_MB,size);
			ReadHandler[0].Install(from, DirectIO_readport, IO_MB,size);
		
		
	}
};

static DirectIO* testdirectio;

void DirectIO_Destroy(Section* sec){
	delete testdirectio;
}

void DirectIO_Init(Section* sec) {
	testdirectio = new DirectIO(sec);
	sec->AddDestroyFunction(&DirectIO_Destroy, true);
}

#endif