'use strict';
var elements = ['html', 'head', 'title', 'base', 'link', 'meta', 'style', 'body', 'article', 'section', 'nav', 'aside', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'footer', 'address', 'p', 'hr', 'pre', 'blockquote', 'ol', 'ul', 'li', 'dl', 'dt', 'dd', 'figure', 'figcaption', 'div', 'main', 'a', 'em', 'strong', 'small', 's', 'cite', 'q', 'dfn', 'abbr', 'data', 'time', 'code', 'var', 'samp', 'kbd', 'sub', 'sup', 'i', 'b', 'u', 'mark', 'ruby', 'rt', 'rp', 'bdi', 'bdo', 'span', 'br', 'wbr', 'ins', 'del', 'img', 'iframe', 'embed', 'object', 'param', 'video', 'audio', 'source', 'track', 'map', 'area', 'math', 'svg', 'table', 'caption', 'colgroup', 'col', 'tbody', 'thead', 'tfoot', 'tr', 'td', 'th', 'form', 'label', 'input', 'button', 'select', 'datalist', 'optgroup', 'option', 'textarea', 'keygen', 'output', 'progress', 'meter', 'fieldset', 'legend', 'script', 'noscript', 'template', 'canvas'],
    limit = 10;

var els = new Map();
elements.forEach(function (el) {
	els.set(el, false);
});

var Game = React.createClass({
	displayName: 'Game',

	getInitialState: function getInitialState() {
		return {
			seconds: 0, // starting time
			timer: 'off', // timer state
			input: '', // input field value
			found: [] // found elements
		};
	},

	componentDidMount: function componentDidMount() {
		//this.timer();
	},

	componentDidUpdate: function componentDidUpdate() {
		if (this.state.found.length === elements.length) this.setState({ timer: 'out' });
	},

	timer: function timer() {
		var _this = this;

		var start = 0,
		    frequence = 1000,
		    millisec = 0,
		    diff = 0,
		    passed = 0;
		var timerInstance = function timerInstance() {
			if (_this.state.timer === 'out') return;
			millisec += frequence;
			diff = Date.now() - start - millisec;
			passed = Math.round(Math.floor(millisec / 1000));
			_this.setState({ seconds: limit - passed });
			if (passed >= limit) {
				_this.setState({
					seconds: 0,
					timer: 'out'
				});
				return;
			}
			setTimeout(timerInstance, frequence - diff);
		};
		start = Date.now();
		this.setState({
			seconds: limit,
			timer: 'on' });
		setTimeout(timerInstance, frequence);
	},

	handleInput: function handleInput(ev) {
		if (this.state.timer === 'off') this.timer();
		var inp = ev.target.value;
		this.setState({ input: inp });
		if (!els.has(inp)) return;
		if (els.get(inp) === false) {
			els.set(inp, true);
			this.setState({
				input: '',
				found: this.state.found.concat(inp)
			});
		}
	},

	render: function render() {
		return React.createElement(
			'section',
			null,
			React.createElement(Counter, { done: this.state.found.length }),
			React.createElement(Input, { val: this.state.input, process: this.handleInput, disabled: this.state.timer === 'out' ? true : false }),
			React.createElement(Timer, { time: this.state.seconds, status: this.state.timer }),
			React.createElement(
				Output,
				{ color: 'green', desc: 'HTML5-Elemente' },
				this.state.found
			),
			React.createElement(
				Report,
				{ show: this.state.timer === 'out' ? true : false },
				this.state.found
			)
		);
	}
});

var Counter = React.createClass({
	displayName: 'Counter',

	render: function render() {
		return React.createElement(
			'div',
			{ id: 'counter' },
			this.props.done,
			' von ',
			elements.length
		);
	}
});

var Input = React.createClass({
	displayName: 'Input',

	render: function render() {
		return React.createElement('input', { type: 'text', value: this.props.val, autoFocus: 'true', disabled: this.props.disabled, onInput: this.props.process });
	}
});

var Timer = React.createClass({
	displayName: 'Timer',

	render: function render() {
		var seconds = this.props.time % 60;
		var minutes = (this.props.time - seconds) / 60;
		seconds = seconds < 10 ? '0' + seconds : seconds.toString();
		return React.createElement(
			'div',
			{ id: 'timer', className: this.props.status },
			minutes,
			':',
			seconds
		);
	}
});

var Output = React.createClass({
	displayName: 'Output',

	render: function render() {
		return React.createElement(
			'div',
			{ className: this.props.color },
			this.props.desc,
			':',
			' ',
			this.props.children.sort().join(', ')
		);
	}
});

var Report = React.createClass({
	displayName: 'Report',

	render: function render() {
		var _this2 = this;

		if (!this.props.show) return React.createElement('span', null);
		var missed = elements.filter(function (el) {
			return _this2.props.children.indexOf(el) < 0;
		});
		return React.createElement(
			'ul',
			{ className: 'elementlist' },
			missed.map(function (el, i) {
				return React.createElement(
					ReportRow,
					{ key: i, style: 'missed' },
					el
				);
			})
		);
	}
});

var ReportRow = React.createClass({
	displayName: 'ReportRow',

	render: function render() {
		return React.createElement(
			'li',
			null,
			React.createElement(
				'code',
				{ className: this.props.style },
				this.props.children
			)
		);
	}
});

ReactDOM.render(React.createElement(Game, null), document.getElementsByTagName('main')[0]);