'use strict';
const elements = [
	'html',
	'head',
	'title',
	'base',
	'link',
	'meta',
	'style',
	'body',
	'article',
	'section',
	'nav',
	'aside',
	'h1',
	'h2',
	'h3',
	'h4',
	'h5',
	'h6',
	'header',
	'footer',
	'address',
	'p',
	'hr',
	'pre',
	'blockquote',
	'ol',
	'ul',
	'li',
	'dl',
	'dt',
	'dd',
	'figure',
	'figcaption',
	'div',
	'main',
	'a',
	'em',
	'strong',
	'small',
	's',
	'cite',
	'q',
	'dfn',
	'abbr',
	'data',
	'time',
	'code',
	'var',
	'samp',
	'kbd',
	'sub',
	'sup',
	'i',
	'b',
	'u',
	'mark',
	'ruby',
	'rt',
	'rp',
	'bdi',
	'bdo',
	'span',
	'br',
	'wbr',
	'ins',
	'del',
	'img',
	'iframe',
	'embed',
	'object',
	'param',
	'video',
	'audio',
	'source',
	'track',
	'map',
	'area',
	'math',
	'svg',
	'table',
	'caption',
	'colgroup',
	'col',
	'tbody',
	'thead',
	'tfoot',
	'tr',
	'td',
	'th',
	'form',
	'label',
	'input',
	'button',
	'select',
	'datalist',
	'optgroup',
	'option',
	'textarea',
	'keygen',
	'output',
	'progress',
	'meter',
	'fieldset',
	'legend',
	'script',
	'noscript',
	'template',
	'canvas'
],
limit = 10;

let els = new Map();
elements.forEach((el) => {
	els.set(el, false);
});

const Game = React.createClass({
	getInitialState: () => {
		return {
			seconds: 0,	// starting time
			timer: 'off',	// timer state
			input: '',	// input field value
			found: []	// found elements
		};
	},

	componentDidMount: function() {
		//this.timer();
	},

	componentDidUpdate: function() {
		if (this.state.found.length === elements.length)
			this.setState({timer: 'out'});
	},

	timer: function() {
		let start = 0,
			frequence = 1000,
			millisec = 0,
			diff = 0,
			passed = 0;
		const timerInstance = () => {
			if (this.state.timer === 'out') return;
			millisec += frequence;
			diff = (Date.now() - start) - millisec;
			passed = Math.round(Math.floor(millisec / 1000));
			this.setState({seconds: limit - passed});
			if (passed >= limit) {
				this.setState({
					seconds: 0,
					timer: 'out'
				});
				return;
			}
			setTimeout(timerInstance, (frequence - diff));
		}
		start = Date.now();
		this.setState({
			seconds: limit,
			timer: 'on'}
		);
		setTimeout(timerInstance, frequence);
	},

	handleInput: function(ev) {
		if (this.state.timer === 'off')
			this.timer();
		let inp = ev.target.value;
		this.setState({input: inp});
		if (!els.has(inp)) return;
		if (els.get(inp) === false) {
			els.set(inp, true);
			this.setState({
				input: '',
				found: this.state.found.concat(inp)
			});
		}
	},

	render: function() {
		return <section>
			<Counter done={this.state.found.length}/>
			<Input val={this.state.input} process={this.handleInput} disabled={(this.state.timer === 'out')? true : false}/>
			<Timer time={this.state.seconds} status={this.state.timer}/>
			<Output color="green" desc="HTML5-Elemente">{this.state.found}</Output>
			<Report show={this.state.timer === 'out'? true : false}>{this.state.found}</Report>
		</section>
	}
});

const Counter = React.createClass({
	render: function() {
		return <div id="counter">
			{this.props.done} von {elements.length}
		</div>;
	}
});

const Input = React.createClass({
	render: function() {
		return <input type="text" value={this.props.val} autoFocus="true" disabled={this.props.disabled} onInput={this.props.process}/>;
	}
});

const Timer = React.createClass({
	render: function() {
		let seconds = this.props.time % 60;
		let minutes = (this.props.time - seconds) / 60;
		seconds = seconds < 10? '0' + seconds : seconds.toString();
		return <div id="timer" className={this.props.status}>{minutes}:{seconds}</div>;
	}
});

const Output = React.createClass({
	render: function() {
		return <div className={this.props.color}>
			{this.props.desc}:{' '}
			{this.props.children.sort().join(', ')}
		</div>;
	}
});

const Report = React.createClass({
	render: function() {
		if (!this.props.show) return <span/>;
		let missed = elements.filter((el) => {
			return this.props.children.indexOf(el) < 0;
		});
		return <ul className="elementlist">
			{missed.map((el, i) => <ReportRow key={i} style="missed">{el}</ReportRow>)}
		</ul>;
	}
});

const ReportRow = React.createClass({
	render: function() {
		return <li><code className={this.props.style}>{this.props.children}</code></li>;
	}
});

ReactDOM.render(
	<Game/>,
	document.getElementsByTagName('main')[0]
);
