﻿[CmdletBinding()]
Param(
    [Parameter(Mandatory=$True, Position=0)]
    [string]$VHDPath,

    [Parameter(Mandatory=$True, Position=1)]
    [ValidateNotNullOrEmpty()]
    [string]$SnapshotName
)

#requires -Version 4.0
#requires -RunAsAdministrator

$vhd = Get-VHD -Path $VHDPath
if(-not $vhd) {
    # Fehlermeldung war schon zu sehen
    return
}
if($vhd.Attached) {
    Write-Error "Der virtuelle Datenträger $VHDPath darf für diesen Vorgang nicht eingebunden sein."
    return
}

$sourcePath = $vhd.Path
$folder = (Split-Path $sourcePath) + [System.IO.Path]::DirectorySeparatorChar
$baseName = Split-Path $vhd.Path -Leaf
$ext = $baseName.Substring($baseName.LastIndexOf('.'))
$branch = $folder + $SnapshotName.Trim().Replace(' ', '-') + $ext

Write-Verbose "Erzeuge $branch ..."
New-VHD -Path $branch -Differencing -ParentPath $sourcePath # | Out-Null

Write-Verbose "$branch einhängen ..."
$mount = Mount-VHD -Path $branch -ReadOnly -Passthru

$disk = $mount | Get-Disk
$winPath = ""
foreach($part in ($disk | Get-Partition)) {
    $winPath = $part.DriveLetter + ":\Windows"
    if(Test-Path -Path $winPath -PathType Container) {
        break
    }
}

if($winPath) {
    Write-Verbose "Erzeuge Boot-Menü-Eintrag für $winPath ..."
    Invoke-Expression "bcdboot $winPath /d /addlast /l de-de"
    if($LASTEXITCODE -ne 0) {
        Write-Error "bcdboot hat einen Fehler beim Erstellen des Boot-Menü-Eintrags gemeldet."
    }
}
else {
    Write-Host "Keinen Windows-Ordner in $branch gefunden."
}

Write-Verbose "$branch wieder entfernen ..."
$mount | Dismount-VHD

Write-Verbose "Alles erledigt."
