﻿[CmdletBinding()]
Param(
    [Parameter(Mandatory=$True, Position=0)]
    [string]$VHDPath,

    [Parameter(Mandatory=$False)]
    [switch]$Force
)

$vhd = Get-VHD -Path $VHDPath
if(-not $vhd) {
    # Fehlermeldung war schon zu sehen
    return
}
if($vhd.Attached) {
    Write-Error "Der virtuelle Datenträger $VHDPath darf für diesen Vorgang nicht eingebunden sein."
    return
}
if(-not $vhd.ParentPath) {
    Write-Error "Der virtuelle Datenträger $VHDPath hat keinen Vorgänger."
    return
}

$delPath = $vhd.Path
$parentPath = $vhd.ParentPath

if(-not $Force) {
    # Sind Sie sicher?
    $title = $MyInvocation.MyCommand
    $message = "$delPath wird GELÖSCHT und anschließend neu angelegt.`r`n`r`n" `
        + "Wollen Sie fortfahren?"
    $yes = New-Object System.Management.Automation.Host.ChoiceDescription "&Ja", `
        "Führt die beschriebenen Operationen aus."
    $no = New-Object System.Management.Automation.Host.ChoiceDescription "&Nein", `
        "Bricht die Ausführung ab."
    $options = [System.Management.Automation.Host.ChoiceDescription[]]($yes, $no)
    $result = $host.ui.PromptForChoice($title, $message, $options, 1) 
    if($result -ne 0)
    {
        Write-Verbose "Abbruch durch Benutzer"
        return
    }
}

Write-Verbose "Lösche $delPath ..."
Remove-Item $delPath

Write-Verbose "Lege $delPath neu an ..."
New-VHD -Path $delPath -ParentPath $parentPath

Write-Verbose "Erledigt."
