﻿[CmdletBinding()]
Param(
    [Parameter(Mandatory=$True, Position=0)]
    [string]$VHDPath,

    [Parameter(Mandatory=$True, Position=1)]
    [string]$SnapshotName
)

$vhd = Get-VHD -Path $VHDPath
if(-not $vhd) {
    # Fehlermeldung war schon zu sehen
    return
}
if($vhd.Attached) {
    Write-Error "Der virtuelle Datenträger $VHDPath darf für diesen Vorgang nicht eingebunden sein."
    return
}

$sourcePath = $vhd.Path
$folder = (Split-Path $sourcePath) + [System.IO.Path]::DirectorySeparatorChar
if($vhd.VhdType -eq [Microsoft.Vhd.PowerShell.VhdType]::Differencing) {
    $baseName = Split-Path $vhd.ParentPath -Leaf
}
else {
    $baseName = Split-Path $vhd.Path -Leaf
}
$ext = $baseName.Substring($baseName.LastIndexOf('.'))
$baseName = $baseName.Substring(0, $baseName.LastIndexOf('.'))
$rename = $baseName + '_' + $SnapshotName.Trim().Replace(' ', '-') + $ext

Write-Verbose "Benenne $sourcePath in $rename um ..."
Rename-Item -Path $sourcePath -NewName $rename

Write-Verbose "Erzeuge $sourcePath neu ..."
New-VHD -Path $sourcePath -Differencing -ParentPath ($folder + $rename) # | Out-Null

Write-Verbose "Erledigt."
