function init() {
	console.log('%c CreateJS Beispielprojekt: Entwickelt von Merlin Schumacher (mls@ct.de) für c\'t. ', 'background: #222; color: #bada55');
	//Initialisierung des Canvas-Elements
	canvas = new createjs.Stage("mainCanvas");

	// Erzeugt einen Ticker der 60 mal pro Sekunde den Inhalt der canvas
	// aktualisiert
	createjs.Ticker.on("tick", canvasRefresh);
	createjs.Ticker.setFPS(60); 

	//Ein blauer Kreis für den Hintergrund wird erzeugt.
	//Zuerst das notwendige Shape-Objekt
	var circle = new createjs.Shape();
	//Anschließend wird die Füllfarbe festgelegt
	circle.graphics.beginFill("blue");
	//Und der Kreis gezeichnet
	circle.graphics.drawCircle(0, 0, 800);
	//Position des Kreises wird festgelegt
	circle.x = 800;
	circle.y = 450;
	//Der Kreis wird auf die Größe 0 skaliert und transparent gemacht
	circle.scaleX = 0;
	circle.scaleY = 0;
	circle.alpha = 0;
	//Der Kreis wird zum Canvas hinzugefügt
	canvas.addChild(circle);

	//Ein Bild wird eingefügt
	var ctlogo = new createjs.Bitmap("ct.png");
	//Das Bild wird auf das 0,4fache seiner Ursprungsgröße herunterskaliert
	ctlogo.x = 590;
	ctlogo.y = 900;
	//Der Ursprung des Bildes wird mittig festgelegt, damit es sich mittig
	//zum Mauscursor bewegt.
	ctlogo.regX = 420;
	ctlogo.regY = 312;
	ctlogo.scaleX = .4;
	ctlogo.scaleY = .4;
	ctlogo.alpha = 0;

	//Erzeugt ein neues Textobjekt. Das Objekt verwendet eine durch die
	//CSS-Datei geladenen Schrift von Google Web Fonts und ist weiß.
	var untertitel = new createjs.Text();
	untertitel.text = 'magazin für\ncomputer\ntechnik'; 
	untertitel.font = '64px "Press Start 2P"';
	untertitel.color = "#fff";

	//Erzeugt einen Schatten für den Text.
	untertitel.shadow = new createjs.Shadow("#000000", 5, 5, 10);
	untertitel.y = 490;
	untertitel.x = 840;
	untertitel.alpha = 0;

	//Erzeugt die Schrift Beweg mich
	var moveme = new createjs.Text('Beweg mich!', '44px Arial', "#fff");
	moveme.y = 160;
	moveme.x = 940;
	moveme.alpha = 0;

	//Zeichnet einen weißen Pfeil
	//Erzeugt das nötige Shape-Objekt
	var arrow = new createjs.Shape();
	//Legt die Strichfarbe fest
	arrow.graphics.beginStroke("#ffffff");
	//Legt die Füllung fest
	arrow.graphics.beginFill("#ffffff");
	//lineTo(x,y) zeichnet Linien, wobei x und y die Zielkoordinaten des
	//Pfeils bezeichnen. moveTo bewegt lediglich den "Cursor"
	arrow.graphics.moveTo(0, 60)
		.lineTo(20, 5)
		.lineTo(30, 20)
		.lineTo(40, 0)
		.lineTo(57, 12)
		.lineTo(40, 28)
		.lineTo(55, 35)
		.closePath();
	arrow.y = 200;
	arrow.x = 840;
	arrow.alpha = 0;

	//Wenn das ct-Logo angeklickt wird und mit heruntergrdrückter Maustaste
	//bewegt wird, verschiebt es sich passend zur Mausposition. Der Hinweis
	//zum bewegen wird von der canvas entfernt. Abschließend wird das
	//c't-Logo als oberstes Objekt platziert.
	ctlogo.on("pressmove", function(evt) {
		evt.target.x = evt.stageX;
		evt.target.y = evt.stageY;
		canvas.removeChild(moveme);
		canvas.removeChild(arrow);
		canvas.setChildIndex(ctlogo, canvas.getNumChildren()-1);
	});

	//Erzeugt einen Tween zur Animation des circlees
	var circleTween = createjs.Tween.get(circle)
	//Setzt die Transparenz des circlees auf 1 und skaliert ihn auf
	//Originalgröße. Die Animation dauert 1000ms
		.to({ alpha: 1, scaleX: 1, scaleY: 1}, 
			1000, createjs.Ease.getPowInOut(2));

	//Erzeugt einen Tween zur Animation des c't-Logos
	createjs.Tween.get(ctlogo)
	//Verzögert den Start der Animation um 300ms
		.wait(300)
	//Das Logo wird auf 0.8 fache Größe skakliert, wird sichtabr
	//und bewegt sich an die Position 225,250.
		.to({ scaleX: .8, scaleY: .8,alpha: 1, y: 450, x: 500 },
			1000, createjs.Ease.getPowInOut(2));

	//Der Untertitel wird nach 1 Sekunde eingeblendet
	createjs.Tween.get(untertitel, { loop: false })
		.wait(1000)
		.to({ alpha: 1 }, 1000, createjs.Ease.getPowInOut(2));


	//Der Beweg-Mich-Hinweis und arrow folgen nach 1,5 Sekunden
	createjs.Tween.get(moveme, { loop: false })
		.wait(1500)
		.to({ alpha: 1 }, 0);

	createjs.Tween.get(arrow, { loop: false })
		.wait(1500)
		.to({ alpha: 1 }, 0);

}

function canvasRefresh(event) {
	canvas.update();
}
