/*
 * Decompiled with CFR 0.152.
 */
package infchem.realrobots;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CallbackSystem {
    public static HashMap<Integer, Callback> callbacks;
    public static Thread callbackThread;
    public static int lastCallback;

    public static void start() {
        callbackThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    long time = System.currentTimeMillis();
                    HashMap<Integer, Callback> hashMap = callbacks;
                    synchronized (hashMap) {
                        Iterator<Map.Entry<Integer, Callback>> it = callbacks.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry<Integer, Callback> pairs = it.next();
                            Callback callback = pairs.getValue();
                            if (callback.getExpiryTime() >= time) continue;
                            callback.abort(null);
                            it.remove();
                        }
                    }
                }
            }
        });
        callbacks = new HashMap();
        callbackThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activateCallback(int callbackNum, Object[] returnObjects) {
        HashMap<Integer, Callback> hashMap = callbacks;
        synchronized (hashMap) {
            Callback callback = callbacks.get(callbackNum);
            if (callback == null) {
                System.out.println("Callback has already been removed.");
                return;
            }
            callback.execute(returnObjects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void abortCallback(int callbackNum, Object[] returnObjects) {
        HashMap<Integer, Callback> hashMap = callbacks;
        synchronized (hashMap) {
            Callback callback = callbacks.get(callbackNum);
            if (callback == null) {
                System.out.println("Callback has already been removed.");
                return;
            }
            callback.abort(returnObjects);
        }
    }

    public static int getCallbackID() {
        return ++lastCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int queueCallback(Callback callback) {
        int callbackID;
        HashMap<Integer, Callback> hashMap = callbacks;
        synchronized (hashMap) {
            callbackID = CallbackSystem.getCallbackID();
            callbacks.put(callbackID, callback);
        }
        return callbackID;
    }

    public static interface Callback {
        public long getExpiryTime();

        public void execute(Object[] var1);

        public void abort(Object[] var1);
    }
}

