/*
 * Decompiled with CFR 0.152.
 */
package infchem.realrobots.config;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static Configuration config;
    public static String piIP;
    public static boolean piEnabled;
    public static String scratchIP;
    public static boolean scratchEnabled;

    public static void init(File file) {
        if (config == null) {
            config = new Configuration(file);
            try {
                config.load();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConfigHandler.updateConfig();
        }
    }

    private static void updateConfig() {
        piIP = config.getString("IP address", Category.RASPI, piIP, "Here you set the IP adress of your PI.");
        piEnabled = config.getBoolean("Enabled", Category.RASPI, piEnabled, "Set to true to enable the communication.");
        scratchIP = config.getString("IP address", Category.SCRATCH, scratchIP, "Here you set the IP adress of the computer where Scratch runs.");
        scratchEnabled = config.getBoolean("Enabled", Category.SCRATCH, scratchEnabled, "Set to true to enable the communication.");
        if (config.hasChanged()) {
            config.save();
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("realrobots")) {
            ConfigHandler.updateConfig();
        }
    }

    static {
        piIP = "127.0.0.1";
        piEnabled = false;
        scratchIP = "127.0.0.1";
        scratchEnabled = false;
    }

    public static class Category {
        public static String RASPI = "raspberrypi";
        public static String SCRATCH = "scratch";
    }
}

