/*
 * Decompiled with CFR 0.152.
 */
package infchem.realrobots.wedo;

import com.codeminders.hidapi.HIDDevice;
import com.codeminders.hidapi.HIDDeviceNotFoundException;
import com.codeminders.hidapi.HIDManager;
import infchem.realrobots.connector.ConnectorHID;
import java.io.IOException;
import java.util.Arrays;

public class ConnectorWeDo
extends ConnectorHID {
    static final int VENDOR_ID = 1684;
    static final int PRODUCT_ID = 3;
    private static final int BUFSIZE = 8;
    private static final String DESC = "LEGO WeDo";
    private Double leftMotorPower = 0.0;
    private Double rightMotorPower = 0.0;
    public static byte[] al = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};

    private int getTiltByte() throws Exception {
        byte[] buf = ConnectorWeDo.readHID(1684, 3, DESC);
        String[] tiltSensor = new String[]{"38", "39", "40"};
        if (Arrays.asList(tiltSensor).contains(String.valueOf(buf[3]))) {
            return 3;
        }
        if (Arrays.asList(tiltSensor).contains(String.valueOf(buf[5]))) {
            return 5;
        }
        return 0;
    }

    private int getDistanceByte() throws Exception {
        byte[] buf = ConnectorWeDo.readHID(1684, 3, DESC);
        String[] distanceSensor = new String[]{"-76", "-77"};
        if (Arrays.asList(distanceSensor).contains(String.valueOf(buf[3]))) {
            return 3;
        }
        if (Arrays.asList(distanceSensor).contains(String.valueOf(buf[5]))) {
            return 5;
        }
        return 0;
    }

    public Object[] getTilt() throws Exception {
        Object[] result = new Object[]{""};
        if (this.getTiltByte() == 0) {
            throw new Exception("No tilt sensor found!");
        }
        String[] normal = new String[]{"-128", "-127", "-126", "-125", "124", "125", "126", "127", "128"};
        String[] forward = new String[]{"-79", "-78", "-77", "-76", "-75", "-74", "-73", "-72"};
        String[] backward = new String[]{"24", "25", "26", "27"};
        String[] left = new String[]{"-27", "-26", "-25", "-24"};
        String[] right = new String[]{"72", "73", "74", "75", "76", "77", "78", "79"};
        byte[] buf = ConnectorWeDo.readHID(1684, 3, DESC);
        String s = String.valueOf(buf[this.getTiltByte() - 1]);
        if (Arrays.asList(normal).contains(s)) {
            result[0] = "0";
        }
        if (Arrays.asList(forward).contains(s)) {
            result[0] = "1";
        }
        if (Arrays.asList(backward).contains(s)) {
            result[0] = "3";
        }
        if (Arrays.asList(left).contains(s)) {
            result[0] = "4";
        }
        if (Arrays.asList(right).contains(s)) {
            result[0] = "2";
        }
        return result;
    }

    public Object[] getDistance() throws Exception {
        Object[] result = new Object[]{""};
        if (this.getDistanceByte() == 0) {
            throw new Exception("No distance sensor found!");
        }
        byte[] buf = ConnectorWeDo.readHID(1684, 3, DESC);
        result[0] = String.valueOf((buf[this.getDistanceByte() - 1] & 0xFF) - 69);
        return result;
    }

    public Object[] getLeftRotation() throws Exception {
        Object[] result = new Object[]{""};
        byte[] buf = ConnectorWeDo.readHID(1684, 3, DESC);
        result[0] = buf[2] > 233 ? String.valueOf(buf[3]) : String.valueOf(buf[2]);
        return result;
    }

    public synchronized void motorControl() throws Exception {
        HIDDevice dev = null;
        try {
            dev = HIDManager.getInstance().openById(1684, 3, null);
        }
        catch (HIDDeviceNotFoundException e) {
            throw new Exception("WeDo not found!");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] buf = new byte[8];
        String lmp_str = String.valueOf(this.getLeftMotorPower().intValue());
        byte lmp_byte = new Byte(lmp_str);
        String rmp_str = String.valueOf(this.getRightMotorPower().intValue());
        byte rmp_byte = new Byte(rmp_str);
        byte[] weco = new byte[]{0, 64, lmp_byte, rmp_byte, 0, 0, 0, 0, 0};
        try {
            dev.write(weco);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            dev.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private int locateTiltSensor() {
        return 0;
    }

    public Double getLeftMotorPower() {
        return this.leftMotorPower;
    }

    public void setLeftMotorPower(Double leftMotorPower) {
        this.leftMotorPower = leftMotorPower;
    }

    public Double getRightMotorPower() {
        return this.rightMotorPower;
    }

    public void setRightMotorPower(Double rightMotorPower) {
        this.rightMotorPower = rightMotorPower;
    }

    public Object[] getRaw() throws Exception {
        Object[] result = new Object[]{""};
        byte[] buf = ConnectorWeDo.readHID(1684, 3, DESC);
        result[0] = Arrays.toString(buf);
        return result;
    }
}

