package com.linkesoft.bbingo;

import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.view.ContextMenu;
import android.view.ContextMenu.ContextMenuInfo;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.AdapterContextMenuInfo;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.CursorAdapter;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.Toast;

/**
 * Verwalte beliebig viele Wortlisten in einem ListView: Auswahl, Anlegen und Löschen.
 */
public class WordListsActivity extends AppCompatActivity {

	public static final String ID="id"; // Parameter zur Übergabe der ausgewählten ID
	private BBingoDB db;
	private ListView listView;

	@Override
	public void onCreate(Bundle savedInstanceState) {
	    super.onCreate(savedInstanceState);
	    setContentView(R.layout.wordlists);
	    listView = (ListView) findViewById(R.id.wordlist);
	
	    db = new BBingoDB(this);
	    Cursor cursor=db.getWordListsCursor(); // Cursor über alle Einträge, wird vom ListAdapter verwaltet und geschlossen
	    listView.setAdapter(
	    		new SimpleCursorAdapter(this,
	    			android.R.layout.simple_list_item_single_choice, // Layout für Listeneintrag
	    			cursor, 
	    			new String[]{BBingoDB.TITLE}, new int[]{android.R.id.text1},CursorAdapter.FLAG_REGISTER_CONTENT_OBSERVER) // Mapping zwischen ID im Eintragslayout und Feld in der Datenbank
	    		);
	    registerForContextMenu(listView); // zeige popup menu fuer Liste
	    listView.setChoiceMode(ListView.CHOICE_MODE_SINGLE);
	    // wähle aktuellen Eintrag aus
	    long id=Prefs.getID(this);
	    for(int position=0;position<listView.getCount();position++)
	    {
	    	if(id==listView.getItemIdAtPosition(position))
	    	{
	    		listView.setItemChecked(position, true);
	    		break;
	    	}
	    }
		EditWordListFragment editWordListFragment=(EditWordListFragment) getSupportFragmentManager().findFragmentById(R.id.EditWordListFragment);
		if(editWordListFragment!=null)
		{
			editWordListFragment.load(id);
		}
	    
	    listView.setOnItemClickListener(new OnItemClickListener() {
	    	/**
	    	 * Benutzer klickt auf einen Eintrag in der Liste
	    	 */

			@Override
			public void onItemClick(AdapterView<?> list, View v, int position,
					long id) {
				listView.setItemChecked(position, true);
				EditWordListFragment editWordListFragment=(EditWordListFragment) getSupportFragmentManager().findFragmentById(R.id.EditWordListFragment);
				if(editWordListFragment!=null)
				{
					editWordListFragment.save(); // sichere Aenderungen
					editWordListFragment.load(id);
				}
				else if(id==Prefs.getID(WordListsActivity.this)) // zweiter Klick auf Wordliste öffnet Editor als extra Aktivität
				{
					Intent intent = new Intent(WordListsActivity.this, EditWordListActivity.class);
					intent.putExtra(EditWordListActivity.ID, id); // übergebe aktuelle ID
					startActivity(intent);

				}
				Prefs.setID(WordListsActivity.this, id);
			}
		});
	}
	
	@Override
	protected void onDestroy() {
		db.close();
		super.onDestroy();
	}


/**
 * Erzeuge Context(Popup)-Menü, durch langen Tap auf einen Listeintrag ausgewählt
 */
	@Override
	public void onCreateContextMenu(ContextMenu menu, View v, ContextMenuInfo menuInfo) {
		if (v.equals(listView)) {
	        MenuInflater inflater = getMenuInflater();
	        inflater.inflate(R.menu.wordlists_context, menu);
	        AdapterContextMenuInfo info = (AdapterContextMenuInfo) menuInfo;
	        menu.setHeaderTitle(db.getWordList(info.id).title);
			return;
		}
		super.onCreateContextMenu(menu, v, menuInfo);
	}

/**
 * Context-Menü für List-Eintrag wurde durch Tap-and-Hold ausgewählt
 */
	@Override
	public boolean onContextItemSelected(MenuItem item) {
		AdapterContextMenuInfo info = (AdapterContextMenuInfo) item.getMenuInfo();
		switch(item.getItemId()) {
    	case R.id.delete:
    		db.removeWordList(info.id); // lösche Wortliste
			// refresh
			CursorAdapter cursorAdapter =  (CursorAdapter)listView.getAdapter();
			Cursor cursor=db.getWordListsCursor();
			cursorAdapter.changeCursor(cursor);
    		// zeige Bestätigung
    		Toast.makeText(this, R.string.WordListDeleted, Toast.LENGTH_SHORT).show();
    		break;
    	case R.id.edit:
			Intent intent = new Intent(this, EditWordListActivity.class);
			intent.putExtra(EditWordListActivity.ID, info.id); // übergebe aktuelle ID
			startActivity(intent);
    		break;
		}
		return super.onContextItemSelected(item);
	}
// normales Menü zum Anlegen neuer Wortlisten und zum Importieren
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
        MenuInflater inflater = getMenuInflater();
        inflater.inflate(R.menu.wordlists, menu);
		return super.onCreateOptionsMenu(menu);
	}
	
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch(item.getItemId()) {
    	case R.id.add:
    		startActivity(new Intent(this,EditWordListActivity.class)); // keine ID übergeben = neue Wortliste
    		break;
		}
		return super.onOptionsItemSelected(item);
	}
	
}
