package com.linkesoft.bbingo;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

/**
 * Verwaltung von Benutzereinstellungen
 *
 */
public class Prefs {
	private static final String ID="id";
	private static final String NOSOUND="nosound";
	private static final String NEARBY="nearby";
	private static final String USERNAME="username";

	public static void setID(Context ctx,long id)
	{
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		SharedPreferences.Editor editor = prefs.edit();
		editor.putLong(ID, id);
		editor.apply();
	}
	public static long getID(Context ctx) {
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		return prefs.getLong(ID,0);	// default ist 0, d.h. keine ID	
	}
	
	public static void setNoSound(Context ctx,boolean nosound)
	{
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		SharedPreferences.Editor editor = prefs.edit();
		editor.putBoolean(NOSOUND, nosound);
		editor.apply();
	}
	public static boolean getNoSound(Context ctx) {
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		return prefs.getBoolean(NOSOUND,true);	// default ist true, d.h. kein Sound	
	}
	public static void setNearby(Context ctx,boolean nearby)
	{
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		SharedPreferences.Editor editor = prefs.edit();
		editor.putBoolean(NEARBY, nearby);
		editor.apply();
	}
	public static boolean getNearby(Context ctx) {
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		return prefs.getBoolean(NEARBY,false);
	}
	public static void setUserName(Context ctx,String username)
	{
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		SharedPreferences.Editor editor = prefs.edit();
		editor.putString(USERNAME, username);
		editor.apply();
	}
	public static String getUserName(Context ctx) {
		SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		return prefs.getString(USERNAME,"");
	}
}
