/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import processing.core.PApplet;
import processing.core.PGraphics;

public class Knob
extends Controller<Knob> {
    protected float _myDiameter;
    protected float _myRadius;
    protected float myAngle;
    protected float startAngle;
    protected float angleRange;
    protected float resolution = 200.0f;
    protected int _myTickMarksNum = 8;
    protected boolean isShowTickMarks;
    protected boolean isSnapToTickMarks;
    protected int myTickMarkLength = 2;
    protected float myTickMarkWeight = 1.0f;
    protected boolean isShowAngleRange = true;
    protected float currentValue;
    protected float previousValue;
    protected float modifiedValue;
    protected boolean isConstrained;
    protected int _myDragDirection = 0;
    protected int viewStyle = 1;
    public static int autoWidth = 39;
    public static int autoHeight = 39;
    protected float[] autoSpacing = new float[]{10.0f, 20.0f};
    private float scrollSensitivity = 1.0f / this.resolution;

    public Knob(ControlP5 controlP5, String string) {
        this(controlP5, controlP5.getDefaultTab(), string, 0.0f, 100.0f, 0.0f, 0, 0, autoWidth);
        controlP5.register(controlP5.papplet, string, this);
    }

    public Knob(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, float f, float f2, float f3, int n, int n2, int n3) {
        super(controlP5, controllerGroup, string, n, n2, n3, n3);
        this._myValue = f3;
        this.setMin(f);
        this.setMax(f2);
        this._myDiameter = n3;
        this._myRadius = this._myDiameter / 2.0f;
        this._myUnit = (this._myMax - this._myMin) / ((float)Math.PI * 2);
        this.startAngle = 2.3561945f;
        this.angleRange = 4.712389f;
        this.myAngle = this.startAngle;
        this.isConstrained = true;
        this.getCaptionLabel().align(3, 13);
        this.setViewStyle(3);
    }

    @Override
    public Knob setSize(int n, int n2) {
        return this.setRadius(n / 2);
    }

    public Knob setRadius(float f) {
        this._myRadius = f;
        this._myDiameter = this._myRadius * 2.0f;
        this.setWidth((int)this._myDiameter);
        this.setHeight((int)this._myDiameter);
        return this;
    }

    public float getRadius() {
        return this._myRadius;
    }

    public Knob setStartAngle(float f) {
        this.startAngle = f;
        this.setInternalValue(this.modifiedValue);
        return this;
    }

    public float getStartAngle() {
        return this.startAngle;
    }

    public Knob setAngleRange(float f) {
        this.angleRange = f;
        this.setInternalValue(this.modifiedValue);
        return this;
    }

    public float getAngleRange() {
        return this.angleRange;
    }

    public float getAngle() {
        return this.myAngle;
    }

    public boolean isShowAngleRange() {
        return this.isShowAngleRange;
    }

    public Knob setShowAngleRange(boolean bl) {
        this.isShowAngleRange = bl;
        return this;
    }

    public Knob setDragDirection(int n) {
        this._myDragDirection = n == 0 ? 0 : 1;
        return this;
    }

    public int getDragDirection() {
        return this._myDragDirection;
    }

    public Knob setResolution(float f) {
        this.resolution = f;
        return this;
    }

    public float getResolution() {
        return this.resolution;
    }

    public Knob setNumberOfTickMarks(int n) {
        this._myTickMarksNum = n;
        this.showTickMarks();
        return this;
    }

    public int getNumberOfTickMarks() {
        return this._myTickMarksNum;
    }

    public Knob showTickMarks() {
        this.isShowTickMarks = true;
        return this;
    }

    public Knob hideTickMarks() {
        this.isShowTickMarks = false;
        return this;
    }

    public boolean isShowTickMarks() {
        return this.isShowTickMarks;
    }

    public Knob snapToTickMarks(boolean bl) {
        this.isSnapToTickMarks = bl;
        this.update();
        return this;
    }

    public Knob setTickMarkLength(int n) {
        this.myTickMarkLength = n;
        return this;
    }

    public int getTickMarkLength() {
        return this.myTickMarkLength;
    }

    public Knob setTickMarkWeight(float f) {
        this.myTickMarkWeight = f;
        return this;
    }

    public float getTickMarkWeight() {
        return this.myTickMarkWeight;
    }

    public Knob setConstrained(boolean bl) {
        this.isConstrained = bl;
        if (!this.isConstrained) {
            this.setShowAngleRange(false);
        } else {
            this.setShowAngleRange(true);
        }
        return this;
    }

    public boolean isConstrained() {
        return this.isConstrained;
    }

    @Override
    @ControlP5.Invisible
    public Knob updateInternalEvents(PApplet pApplet) {
        if (this.isMousePressed && !this.cp5.isAltDown() && this.isActive) {
            float f = this._myDragDirection == 0 ? (float)(this._myControlWindow.mouseX - this._myControlWindow.pmouseX) : (float)(this._myControlWindow.mouseY - this._myControlWindow.pmouseY);
            this.currentValue += f / this.resolution;
            if (this.isConstrained) {
                this.currentValue = PApplet.constrain((float)this.currentValue, (float)0.0f, (float)1.0f);
            }
            this.setInternalValue(this.currentValue);
        }
        return this;
    }

    @Override
    protected void onEnter() {
        this.isActive = true;
    }

    @Override
    protected void onLeave() {
        this.isActive = false;
    }

    @Override
    @ControlP5.Invisible
    public void mousePressed() {
        float f;
        float f2 = Knob.x(this._myParent.getAbsolutePosition()) + Knob.x(this.position) + this._myRadius;
        if (PApplet.dist((float)f2, (float)(f = Knob.y(this._myParent.getAbsolutePosition()) + Knob.y(this.position) + this._myRadius), (float)this._myControlWindow.mouseX, (float)this._myControlWindow.mouseY) < this._myRadius) {
            this.isActive = true;
            if ((double)PApplet.dist((float)f2, (float)f, (float)this._myControlWindow.mouseX, (float)this._myControlWindow.mouseY) > (double)this._myRadius * 0.6) {
                this.myAngle = PApplet.atan2((float)((float)this._myControlWindow.mouseY - f), (float)((float)this._myControlWindow.mouseX - f2)) - this.startAngle;
                if (this.myAngle < 0.0f) {
                    this.myAngle = (float)Math.PI * 2 + this.myAngle;
                }
                if (this.isConstrained) {
                    this.myAngle %= (float)Math.PI * 2;
                }
                this.currentValue = PApplet.map((float)this.myAngle, (float)0.0f, (float)this.angleRange, (float)0.0f, (float)1.0f);
                this.setInternalValue(this.currentValue);
            }
        }
    }

    @Override
    @ControlP5.Invisible
    public void mouseReleasedOutside() {
        this.isActive = false;
    }

    @Override
    public Knob setMin(float f) {
        this._myMin = f;
        return this;
    }

    @Override
    public Knob setMax(float f) {
        this._myMax = f;
        return this;
    }

    public Knob setRange(float f, float f2) {
        this.setMin(f);
        this.setMax(f2);
        this.update();
        return this;
    }

    protected void setInternalValue(float f) {
        this.modifiedValue = this.isSnapToTickMarks ? (float)PApplet.round((float)(f * (float)this._myTickMarksNum)) / (float)this._myTickMarksNum : f;
        this.currentValue = f;
        this.myAngle = PApplet.map((float)(this.isSnapToTickMarks ? this.modifiedValue : this.currentValue), (float)0.0f, (float)1.0f, (float)this.startAngle, (float)(this.startAngle + this.angleRange));
        if (this.isSnapToTickMarks && this.previousValue != this.modifiedValue && this.isSnapToTickMarks) {
            this.broadcast(2);
            this._myValueLabel.set(this.adjustValue(this.getValue()));
            this.previousValue = this.modifiedValue;
            return;
        }
        if (this.previousValue != this.currentValue) {
            this.broadcast(2);
            this._myValueLabel.set(this.adjustValue(this.getValue()));
            this.previousValue = this.modifiedValue;
        }
    }

    @Override
    public Knob setValue(float f) {
        f = PApplet.map((float)f, (float)this._myMin, (float)this._myMax, (float)0.0f, (float)1.0f);
        if (this.isConstrained) {
            f = PApplet.constrain((float)f, (float)0.0f, (float)1.0f);
        }
        this._myValueLabel.set(this.adjustValue(this.getValue()));
        this.setInternalValue(f);
        return this;
    }

    @Override
    public float getValue() {
        this._myValue = PApplet.map((float)(this._myTickMarksNum > 0 ? this.modifiedValue : this.currentValue), (float)0.0f, (float)1.0f, (float)this._myMin, (float)this._myMax);
        return this._myValue;
    }

    public Knob shuffle() {
        float f = (float)Math.random();
        this.setValue(PApplet.map((float)f, (float)0.0f, (float)1.0f, (float)this.getMin(), (float)this.getMax()));
        return this;
    }

    public Knob setScrollSensitivity(float f) {
        this.scrollSensitivity = f;
        return this;
    }

    @ControlP5.Invisible
    public Knob scrolled(int n) {
        float f = this.getValue();
        float f2 = this.isSnapToTickMarks ? 1.0f / (float)this.getNumberOfTickMarks() : this.scrollSensitivity;
        this.setValue(f += (this.getMax() - this.getMin()) * ((float)(-n) * f2));
        return this;
    }

    @Override
    @ControlP5.Invisible
    public Knob update() {
        this.setValue(this._myValue);
        return this;
    }

    public Knob setViewStyle(int n) {
        this.viewStyle = n;
        return this;
    }

    public int getViewStyle() {
        return this.viewStyle;
    }

    @Override
    @ControlP5.Invisible
    public Knob updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myControllerView = new KnobView();
                break;
            }
            case 1: 
            case 2: {
                this._myControllerView = new KnobView();
                break;
            }
        }
        return this;
    }

    @Deprecated
    public Knob setOffsetAngle(float f) {
        return this.setStartAngle(f);
    }

    @Deprecated
    public float value() {
        return this.getValue();
    }

    @Deprecated
    public Knob setDisplayStyle(int n) {
        this.viewStyle = n;
        return this;
    }

    @Deprecated
    public int getDisplayStyle() {
        return this.viewStyle;
    }

    @Deprecated
    @ControlP5.Invisible
    public Knob setSensitivity(float f) {
        this.scrollSensitivity = f;
        return this;
    }

    @Deprecated
    public Knob showTickMarks(boolean bl) {
        this.isShowTickMarks = bl;
        return this;
    }

    class KnobView
    implements ControllerView<Knob> {
        KnobView() {
        }

        @Override
        public void display(PGraphics pGraphics, Knob knob) {
            pGraphics.translate((float)((int)Knob.this.getRadius()), (float)((int)Knob.this.getRadius()));
            pGraphics.pushMatrix();
            pGraphics.ellipseMode(3);
            pGraphics.noStroke();
            pGraphics.fill(Knob.this.getColor().getBackground());
            pGraphics.ellipse(0.0f, 0.0f, Knob.this.getRadius() * 2.0f, Knob.this.getRadius() * 2.0f);
            pGraphics.popMatrix();
            int n = Knob.this.isActive() ? Knob.this.getColor().getActive() : Knob.this.getColor().getForeground();
            pGraphics.pushMatrix();
            if (Knob.this.getViewStyle() == 1) {
                pGraphics.rotate(Knob.this.getAngle());
                pGraphics.stroke(n);
                pGraphics.strokeWeight(Knob.this.getTickMarkWeight());
                pGraphics.line(0.0f, 0.0f, Knob.this.getRadius(), 0.0f);
            } else if (Knob.this.getViewStyle() == 2) {
                pGraphics.rotate(Knob.this.getAngle());
                pGraphics.fill(n);
                pGraphics.ellipse(Knob.this.getRadius() * 0.75f, 0.0f, Knob.this.getRadius() * 0.2f, Knob.this.getRadius() * 0.2f);
            } else if (Knob.this.getViewStyle() == 3) {
                pGraphics.fill(n);
                pGraphics.arc(0.0f, 0.0f, Knob.this.getRadius() * 1.8f, Knob.this.getRadius() * 1.8f, Knob.this.getStartAngle(), Knob.this.getAngle() + (Knob.this.getStartAngle() == Knob.this.getAngle() ? 0.06f : 0.0f));
                pGraphics.fill(pGraphics.red(Knob.this.getColor().getBackground()), pGraphics.green(Knob.this.getColor().getBackground()), pGraphics.blue(Knob.this.getColor().getBackground()), 255.0f);
                pGraphics.ellipse(0.0f, 0.0f, Knob.this.getRadius() * 1.2f, Knob.this.getRadius() * 1.2f);
            }
            pGraphics.popMatrix();
            pGraphics.pushMatrix();
            pGraphics.rotate(Knob.this.getStartAngle());
            if (Knob.this.isShowTickMarks()) {
                float f = Knob.this.getAngleRange() / (float)Knob.this.getNumberOfTickMarks();
                pGraphics.stroke(Knob.this.getColor().getForeground());
                pGraphics.strokeWeight(Knob.this.getTickMarkWeight());
                for (int i = 0; i <= Knob.this.getNumberOfTickMarks(); ++i) {
                    pGraphics.line(Knob.this.getRadius() + 2.0f, 0.0f, Knob.this.getRadius() + (float)Knob.this.getTickMarkLength() + 2.0f, 0.0f);
                    pGraphics.rotate(f);
                }
            } else if (Knob.this.isShowAngleRange()) {
                pGraphics.stroke(Knob.this.getColor().getForeground());
                pGraphics.strokeWeight(Knob.this.getTickMarkWeight());
                pGraphics.line(Knob.this.getRadius() + 2.0f, 0.0f, Knob.this.getRadius() + (float)Knob.this.getTickMarkLength() + 2.0f, 0.0f);
                pGraphics.rotate(Knob.this.getAngleRange());
                pGraphics.line(Knob.this.getRadius() + 2.0f, 0.0f, Knob.this.getRadius() + (float)Knob.this.getTickMarkLength() + 2.0f, 0.0f);
            }
            pGraphics.noStroke();
            pGraphics.popMatrix();
            pGraphics.pushMatrix();
            pGraphics.translate((float)(-Knob.this.getWidth() / 2), (float)(-Knob.this.getHeight() / 2));
            if (Knob.this.isLabelVisible) {
                Knob.this._myCaptionLabel.draw(pGraphics, 0, 0, knob);
                Knob.this._myValueLabel.align(3, 3);
                Knob.this._myValueLabel.draw(pGraphics, 0, 0, knob);
            }
            pGraphics.popMatrix();
        }
    }
}

