/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.CDrawable;
import controlP5.ControlEvent;
import controlP5.ControlListener;
import controlP5.ControlP5;
import controlP5.Controller;
import controlP5.ControllerGroup;
import controlP5.ControllerView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.event.KeyEvent;

public class DropdownList
extends Controller<DropdownList>
implements ControlListener {
    private int _myType = 1;
    protected int _myBackgroundColor = 0xFFFFFF;
    protected int itemHeight = 13;
    protected int barHeight = 10;
    private float scrollSensitivity = 1.0f;
    private boolean isOpen = true;
    protected List<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
    protected int itemRange = 5;
    protected int itemHover = -1;
    private int itemIndexOffset = 0;
    private int itemSpacing = 1;
    private int _myDirection = 40;
    private boolean isBarVisible = true;
    public static final int LIST = 0;
    public static final int DROPDOWN = 1;
    public static final int CHECKBOX = 2;
    public static final int TREE = 3;

    public DropdownList(ControlP5 controlP5, String string) {
        this(controlP5, (ControllerGroup<?>)controlP5.getDefaultTab(), string, 0, 0, 99, 199);
        controlP5.register(controlP5.papplet, string, this);
    }

    protected DropdownList(ControlP5 controlP5, ControllerGroup<?> controllerGroup, String string, int n, int n2, int n3, int n4) {
        super(controlP5, controllerGroup, string, n, n2, n3, n4);
        this.updateHeight();
        this.getValueLabel().align(37, 3);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public DropdownList open() {
        return this.setOpen(true);
    }

    public DropdownList close() {
        return this.setOpen(false);
    }

    public DropdownList setOpen(boolean bl) {
        this.isOpen = bl;
        return this;
    }

    @Override
    public int getHeight() {
        return this.isOpen ? super.getHeight() : this.barHeight;
    }

    public DropdownList setType(int n) {
        this._myType = n;
        return this;
    }

    public void setDirection(int n) {
        this._myDirection = n == 38 ? 38 : 40;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean inside() {
        float f = PApplet.max((float)0.0f, (float)(DropdownList.x(this.position) + DropdownList.x(this._myParent.getAbsolutePosition())));
        float f2 = PApplet.min((float)this.cp5.pgw, (float)(DropdownList.x(this.position) + DropdownList.x(this._myParent.getAbsolutePosition()) + (float)this.getWidth()));
        float f3 = PApplet.max((float)0.0f, (float)(DropdownList.y(this.position) + DropdownList.y(this._myParent.getAbsolutePosition())));
        float f4 = PApplet.min((float)this.cp5.pgh, (float)(DropdownList.y(this.position) + DropdownList.y(this._myParent.getAbsolutePosition()) + (float)this.getHeight()));
        if (f4 < f3) {
            float f5 = f3;
            f3 = f4;
            f4 = f5;
        }
        if (!((float)this._myControlWindow.mouseX > f)) return false;
        if (!((float)this._myControlWindow.mouseX < f2)) return false;
        float f6 = this._myControlWindow.mouseY;
        float f7 = f4 < f3 ? f4 : f3;
        if (!(f6 > f7)) return false;
        float f8 = this._myControlWindow.mouseY;
        float f9 = f3 < f4 ? f4 : f3;
        if (!(f8 < f9)) return false;
        return true;
    }

    @Override
    protected void onRelease() {
        if (!this.isDragged) {
            double d;
            int n;
            if (this.getPointer().y() >= 0 && this.getPointer().y() <= this.barHeight) {
                this.setOpen(!this.isOpen());
            } else if (this.isOpen && (n = (int)(d = Math.floor((this.getPointer().y() - this.barHeight) / this.itemHeight)) + this.itemIndexOffset) < this.items.size()) {
                Map<String, Object> map = this.items.get(n);
                switch (this._myType) {
                    case 0: {
                        this.setValue(n);
                        for (Map<String, Object> map2 : this.items) {
                            map2.put("state", false);
                        }
                        map.put("state", !ControlP5.b(map.get("state")));
                        break;
                    }
                    case 1: {
                        this.setValue(n);
                        this.setOpen(false);
                        this.getCaptionLabel().setText(map.get("text").toString());
                        break;
                    }
                    case 2: {
                        map.put("state", !ControlP5.b(map.get("state")));
                    }
                }
            }
        }
    }

    @Override
    protected void onDrag() {
        this.scroll(this.getPointer().dy());
    }

    @Override
    protected void onScroll(int n) {
        this.scroll(n);
    }

    private void scroll(int n) {
        if (this.isOpen) {
            this.itemIndexOffset += n;
            this.itemIndexOffset = (int)Math.floor(Math.max(0, Math.min(this.itemIndexOffset, this.items.size() - this.itemRange)));
            this.itemHover = -2;
        }
    }

    @Override
    protected void onLeave() {
        this.itemHover = -1;
    }

    private void updateHover() {
        if (this.getPointer().y() > this.barHeight) {
            double d = Math.floor((this.getPointer().y() - this.barHeight) / this.itemHeight);
            this.itemHover = (int)((double)this.itemIndexOffset + d);
        } else {
            this.itemHover = -1;
        }
    }

    @Override
    protected void onEnter() {
        this.updateHover();
    }

    @Override
    protected void onMove() {
        this.updateHover();
    }

    @Override
    protected void onEndDrag() {
        this.updateHover();
    }

    private int updateHeight() {
        this.itemRange = (PApplet.abs((int)this.getHeight()) - (this.isBarVisible() ? this.barHeight : 0)) / this.itemHeight;
        return this.itemHeight * (this.items.size() < this.itemRange ? this.items.size() : this.itemRange);
    }

    public DropdownList setItemHeight(int n) {
        this.itemHeight = n;
        this.updateHeight();
        return this;
    }

    public DropdownList setBarHeight(int n) {
        this.barHeight = n;
        this.updateHeight();
        return this;
    }

    public int getBarHeight() {
        return this.barHeight;
    }

    public DropdownList setScrollSensitivity(float f) {
        this.scrollSensitivity = f;
        return this;
    }

    public DropdownList setBarVisible(boolean bl) {
        this.isBarVisible = bl;
        this.updateHeight();
        return this;
    }

    public boolean isBarVisible() {
        return this.isBarVisible;
    }

    private Map<String, Object> getDefaultItemMap(String string, Object object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", string);
        hashMap.put("text", string);
        hashMap.put("value", object);
        hashMap.put("color", this.getColor());
        hashMap.put("view", new CDrawable(){

            @Override
            public void draw(PGraphics pGraphics) {
            }
        });
        hashMap.put("state", false);
        return hashMap;
    }

    public DropdownList addItem(String string, Object object) {
        Map<String, Object> map = this.getDefaultItemMap(string, object);
        this.items.add(map);
        return this;
    }

    public DropdownList addItems(String[] stringArray) {
        this.addItems(Arrays.asList(stringArray));
        return this;
    }

    public DropdownList addItems(List<String> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addItem(list.get(i).toString(), i);
        }
        return this;
    }

    public DropdownList addItems(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.addItem(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public DropdownList setItems(String[] stringArray) {
        this.setItems(Arrays.asList(stringArray));
        return this;
    }

    public DropdownList setItems(List<String> list) {
        this.items.clear();
        return this.addItems(list);
    }

    public DropdownList setItems(Map<String, Object> map) {
        this.items.clear();
        return this.addItems(map);
    }

    public DropdownList removeItems(List<String> list) {
        for (String string : list) {
            this.removeItem(string);
        }
        return this;
    }

    public DropdownList removeItem(String string) {
        if (string != null) {
            ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> map : this.items) {
                if (!string.equals(map.get("name"))) continue;
                arrayList.add(map);
            }
            this.items.removeAll(arrayList);
        }
        return this;
    }

    public void updateItemIndexOffset() {
        int n = this.items.size() > this.itemRange ? this.itemIndexOffset + this.itemRange : this.items.size();
        int n2 = n - this.items.size();
        if (n2 >= 0) {
            this.itemIndexOffset -= n2;
        }
    }

    public Map<String, Object> getItem(int n) {
        return this.items.get(n);
    }

    public Map<String, Object> getItem(String string) {
        if (string != null) {
            for (Map<String, Object> map : this.items) {
                if (!string.equals(map.get("name"))) continue;
                return map;
            }
        }
        return Collections.EMPTY_MAP;
    }

    public List getItems() {
        return Collections.unmodifiableList(this.items);
    }

    public DropdownList clear() {
        for (int i = this.items.size() - 1; i >= 0; --i) {
            this.items.remove(i);
        }
        this.items.clear();
        this.itemIndexOffset = 0;
        return this;
    }

    @Override
    public void controlEvent(ControlEvent controlEvent) {
    }

    public DropdownList setBackgroundColor(int n) {
        this._myBackgroundColor = n;
        return this;
    }

    public int getBackgroundColor() {
        return this._myBackgroundColor;
    }

    @Override
    @ControlP5.Invisible
    public DropdownList updateDisplayMode(int n) {
        this._myDisplayMode = n;
        switch (n) {
            case 0: {
                this._myControllerView = new DropdownListView();
                break;
            }
        }
        return this;
    }

    @Override
    public void keyEvent(KeyEvent keyEvent) {
        if (this.isInside && keyEvent.getAction() == 1) {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.scroll(keyEvent.isAltDown() ? -this.itemIndexOffset : (keyEvent.isShiftDown() ? -10 : -1));
                    this.updateHover();
                    break;
                }
                case 40: {
                    this.scroll(keyEvent.isAltDown() ? this.items.size() - this.itemRange : (keyEvent.isShiftDown() ? 10 : 1));
                    this.updateHover();
                    break;
                }
                case 37: {
                    break;
                }
                case 39: {
                    break;
                }
                case 10: {
                    this.onRelease();
                }
            }
        }
    }

    public static class DropdownListView
    implements ControllerView<DropdownList> {
        @Override
        public void display(PGraphics pGraphics, DropdownList dropdownList) {
            int n;
            pGraphics.noStroke();
            if (dropdownList.isBarVisible()) {
                n = dropdownList.itemHover == -1 && dropdownList.isInside && !dropdownList.isDragged ? 1 : 0;
                pGraphics.fill(n != 0 ? dropdownList.getColor().getForeground() : dropdownList.getColor().getBackground());
                pGraphics.rect(0.0f, 0.0f, (float)dropdownList.getWidth(), (float)dropdownList.barHeight);
                pGraphics.pushMatrix();
                pGraphics.translate((float)(dropdownList.getWidth() - 8), (float)(dropdownList.barHeight / 2 - 2));
                pGraphics.fill(dropdownList.getColor().getCaptionLabel());
                if (dropdownList.isOpen()) {
                    pGraphics.triangle(-3.0f, 0.0f, 3.0f, 0.0f, 0.0f, 3.0f);
                } else {
                    pGraphics.triangle(-3.0f, 3.0f, 3.0f, 3.0f, 0.0f, 0.0f);
                }
                pGraphics.popMatrix();
                dropdownList.getCaptionLabel().draw(pGraphics, 4, dropdownList.barHeight / 2);
            }
            if (dropdownList.isOpen()) {
                int n2;
                n = dropdownList.isBarVisible() ? dropdownList.barHeight : 0;
                int n3 = dropdownList.updateHeight();
                pGraphics.pushMatrix();
                pGraphics.fill(dropdownList.getBackgroundColor());
                pGraphics.rect(0.0f, (float)n, (float)dropdownList.getWidth(), (float)n3);
                pGraphics.pushMatrix();
                pGraphics.translate(0.0f, (float)(n == 0 ? 0 : dropdownList.barHeight + dropdownList.itemSpacing));
                dropdownList.updateItemIndexOffset();
                int n4 = dropdownList.itemIndexOffset;
                int n5 = dropdownList.items.size() > dropdownList.itemRange ? dropdownList.itemIndexOffset + dropdownList.itemRange : dropdownList.items.size();
                for (n2 = n4; n2 < n5; ++n2) {
                    Map<String, Object> map = dropdownList.items.get(n2);
                    CColor cColor = (CColor)map.get("color");
                    pGraphics.fill(ControlP5.b(map.get("state")) ? cColor.getActive() : (n2 == dropdownList.itemHover ? (dropdownList.isMousePressed ? cColor.getActive() : cColor.getForeground()) : cColor.getBackground()));
                    pGraphics.rect(0.0f, 0.0f, (float)dropdownList.getWidth(), (float)(dropdownList.itemHeight - 1));
                    dropdownList.getValueLabel().set(map.get("text").toString()).draw(pGraphics, 4, dropdownList.itemHeight / 2);
                    pGraphics.translate(0.0f, (float)dropdownList.itemHeight);
                }
                pGraphics.popMatrix();
                if (dropdownList.isInside && (n2 = dropdownList.items.size() - dropdownList.itemRange) > 0) {
                    pGraphics.fill(dropdownList.getColor().getCaptionLabel());
                    pGraphics.pushMatrix();
                    int n6 = 4;
                    int n7 = n6 / 2;
                    pGraphics.translate((float)(dropdownList.getWidth() - n6), (float)dropdownList.barHeight);
                    int n8 = (int)PApplet.map((float)((float)Math.log(n2 * 10)), (float)0.0f, (float)10.0f, (float)n3, (float)0.0f);
                    int n9 = (int)PApplet.map((float)dropdownList.itemIndexOffset, (float)0.0f, (float)n2, (float)n7, (float)(n3 - n8 - n7));
                    pGraphics.rect(0.0f, (float)n9, (float)n7, (float)n8);
                    pGraphics.popMatrix();
                }
                pGraphics.popMatrix();
            }
        }
    }
}

