/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Button;
import controlP5.ControlP5;
import controlP5.Textfield;
import controlP5.Textlabel;
import java.io.File;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;

public class mal_o_mat_2_0
extends PApplet {
    PApplet app = this;
    ControlP5 cp5;
    int kontrollfeldBreite = 180;
    int randBreite = 5;
    int dXBild = this.kontrollfeldBreite;
    int dYBild = this.randBreite;
    int dXVorschau = this.randBreite;
    int dYVorschau = this.randBreite;
    Pinsel aktuellerPinsel;
    RadierPinsel radierPinsel;
    LinienPinsel linienPinsel;
    SpruehPinsel spruehPinsel;
    Bild bild;
    PinselVorschau vorschau;

    public void setup() {
        this.surface.setResizable(true);
        this.surface.setSize(300, 230);
        this.colorMode(1, 100.0f);
        this.background(90);
        this.initStartKontrollelemente();
    }

    public void draw() {
        this.background(90);
        if (this.bild == null) {
            return;
        }
        if (this.mousePressed) {
            this.aktuellerPinsel.zeichnen();
        }
        this.bild.anzeigen();
        this.vorschau.anzeigen();
        this.fill(0);
        this.textSize(11.0f);
        this.text("Pinselvorschau", this.randBreite, 120.0f);
        this.text("'m' --> Tastaturk\u00fcrzel anzeigen", this.randBreite, this.height - 10);
    }

    public void mouseReleased() {
        if (this.bild == null) {
            return;
        }
        if (this.bild.wirdBearbeitet) {
            this.bild.malenBeenden();
        }
        if (this.vorschau.wirdBearbeitet) {
            this.vorschau.malenBeenden();
        }
    }

    public void keyPressed() {
        if (this.bild == null) {
            return;
        }
        this.loop();
        switch (this.key) {
            case '1': {
                this.pinselWaehlen(this.linienPinsel);
                break;
            }
            case '2': {
                this.pinselWaehlen(this.spruehPinsel);
                break;
            }
            case '0': {
                this.pinselWaehlen(this.radierPinsel);
                break;
            }
            case 'z': {
                this.bild.undo();
                break;
            }
            case 's': {
                this.bild.speichern();
                break;
            }
            case 'o': {
                this.bild.oeffnen();
                break;
            }
            case 'l': {
                this.bild.loeschen();
                break;
            }
            case 'r': {
                this.reset();
                break;
            }
            case 'm': {
                this.noLoop();
                this.tastaturkuerzelAnzeigen();
                break;
            }
        }
    }

    public void initStartKontrollelemente() {
        this.cp5 = new ControlP5((PApplet)this);
        this.cp5.setColorCaptionLabel(0);
        this.cp5.setFont(this.createFont("Arial", 12.0f));
        this.cp5.setColorBackground(-1);
        ((Textlabel)((Textlabel)this.cp5.addTextlabel("label").setPosition(70.0f, 20.0f)).setColorValue(-16777216)).setFont(this.createFont("Arial", 20.0f)).setText("c't Mal-o-Mat 2.0");
        ((Textfield)this.cp5.addTextfield("breite").setPosition(70.0f, 60.0f)).setSize(70, 30).setColor(-16777216).setInputFilter(1).setValue("640");
        ((Textfield)this.cp5.addTextfield("hoehe").setPosition(160.0f, 60.0f)).setSize(70, 30).setColor(-16777216).setInputFilter(1).setValue("480");
        ((Button)((Button)((Button)this.cp5.addButton("initNeu").setLabel("Neues Bild")).setPosition(70.0f, 120.0f)).setSize(160, 30)).setFont(this.createFont("Arial", 12.0f));
        ((Button)((Button)((Button)this.cp5.addButton("initMitBildDatei").setLabel("Bild laden")).setPosition(70.0f, 170.0f)).setSize(160, 30)).setFont(this.createFont("Arial", 12.0f));
    }

    public void initNeu() {
        this.initialisiere();
        this.aktualisiereFensterGroesse();
    }

    public void initMitBildDatei() {
        this.initialisiere();
        this.bild.oeffnen();
    }

    public void initialisiere() {
        this.cp5.setVisible(false);
        int breite = Integer.parseInt(((Textfield)this.cp5.getController("breite")).getText());
        int hoehe = Integer.parseInt(((Textfield)this.cp5.getController("hoehe")).getText());
        this.bild = new Bild(breite, hoehe);
        this.vorschau = new PinselVorschau();
        this.radierPinsel = new RadierPinsel();
        this.linienPinsel = new LinienPinsel();
        this.spruehPinsel = new SpruehPinsel();
        this.aktuellerPinsel = this.linienPinsel;
        this.aktuellerPinsel.aktiv(true);
    }

    public void aktualisiereFensterGroesse() {
        int breite = this.kontrollfeldBreite + this.bild.pg.width + this.randBreite;
        int hoehe = this.bild.pg.height + 2 * this.randBreite;
        hoehe = mal_o_mat_2_0.constrain((int)hoehe, (int)480, (int)Integer.MAX_VALUE);
        this.surface.setSize(breite, hoehe);
    }

    public void reset() {
        this.aktuellerPinsel.aktiv(false);
        this.bild = null;
        this.surface.setSize(300, 230);
        this.cp5.setVisible(true);
    }

    public void pinselWaehlen(Pinsel p) {
        this.aktuellerPinsel.aktiv(false);
        this.aktuellerPinsel = p;
        this.aktuellerPinsel.aktiv(true);
    }

    public void textAnzeigen(String text) {
        int textKastenBreite = this.bild.pg.width - 2 * this.randBreite;
        int textKastenHoehe = this.height - 4 * this.randBreite;
        int x = this.dXBild + this.bild.pg.width / 2 - textKastenBreite / 2;
        int y = this.height / 2 - textKastenHoehe / 2;
        this.fill(95, 80.0f);
        this.noStroke();
        this.rect(x, y, textKastenBreite, textKastenHoehe);
        float textGroesse = (float)(textKastenBreite * textKastenHoehe / text.length()) / 50.0f;
        textGroesse = mal_o_mat_2_0.constrain((float)textGroesse, (float)10.0f, (float)25.0f);
        PFont myFont = this.createFont("Arial", textGroesse);
        this.fill(0);
        this.textFont(myFont);
        this.text(text, x + this.randBreite, y + this.randBreite, textKastenBreite, textKastenHoehe);
    }

    public void tastaturkuerzelAnzeigen() {
        this.textAnzeigen("Tastaturk\u00fcrzel\n0      --> Radierer\n1-9   --> Pinsel ausw\u00e4hlen\no      --> Bild \u00f6ffnen\ns      --> Bild speichern\nz      --> Undo\nl       --> L\u00f6schen\nr       --> Reset\nm     --> Tastaturk\u00fcrzel anzeigen\n\nAnzeige schlie\u00dfen mit beliebiger Taste");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"mal_o_mat_2_0"};
        if (passedArgs != null) {
            PApplet.main((String[])mal_o_mat_2_0.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    public class Bild {
        PGraphics pg;
        UndoSpeicher undoSpeicher;
        boolean wirdBearbeitet = false;

        Bild(int breite, int hoehe) {
            this.pg = mal_o_mat_2_0.this.createGraphics(breite, hoehe);
            this.pg.beginDraw();
            this.pg.colorMode(1, 100.0f);
            this.pg.background(100);
            this.pg.endDraw();
            this.undoSpeicher = new UndoSpeicher(this);
        }

        public void anzeigen() {
            mal_o_mat_2_0.this.image((PImage)this.pg, mal_o_mat_2_0.this.dXBild, mal_o_mat_2_0.this.dYBild);
        }

        public void malenBeenden() {
            this.wirdBearbeitet = false;
            this.undoSpeicher.save();
        }

        public void bildGroesseAendern(int breite, int hoehe) {
            PGraphics pgNeu = mal_o_mat_2_0.this.createGraphics(breite, hoehe);
            pgNeu.beginDraw();
            pgNeu.colorMode(1, 100.0f);
            pgNeu.background(100);
            pgNeu.image((PImage)this.pg, 0.0f, 0.0f);
            pgNeu.endDraw();
            this.pg = pgNeu;
            mal_o_mat_2_0.this.aktualisiereFensterGroesse();
        }

        public void undo() {
            PImage letztesBild = this.undoSpeicher.undo();
            this.bildGroesseAendern(letztesBild.width, letztesBild.height);
            this.pg.beginDraw();
            this.pg.image(letztesBild, 0.0f, 0.0f);
            this.pg.endDraw();
        }

        public void loeschen() {
            this.pg.beginDraw();
            this.pg.fill(100);
            this.pg.noStroke();
            this.pg.rect(0.0f, 0.0f, (float)this.pg.width, (float)this.pg.height);
            this.pg.endDraw();
            this.malenBeenden();
        }

        public boolean mausImBild() {
            return mal_o_mat_2_0.this.mouseX > mal_o_mat_2_0.this.dXBild && mal_o_mat_2_0.this.mouseX < mal_o_mat_2_0.this.bild.pg.width + mal_o_mat_2_0.this.dXBild && mal_o_mat_2_0.this.mouseY > mal_o_mat_2_0.this.dYBild && mal_o_mat_2_0.this.mouseY < mal_o_mat_2_0.this.dYBild + mal_o_mat_2_0.this.bild.pg.height;
        }

        public void speichern() {
            mal_o_mat_2_0.this.selectOutput("Bild Speichern:", "speichernAbschliessen", null, this);
        }

        public void speichernAbschliessen(File file) {
            if (file != null) {
                this.pg.save(file.getPath());
            }
        }

        public void oeffnen() {
            mal_o_mat_2_0.this.selectInput("Bild \u00d6ffnen:", "oeffnenAbschliessen", null, this);
        }

        public void oeffnenAbschliessen(File file) {
            if (file != null) {
                PImage geladenesBild = mal_o_mat_2_0.this.loadImage(file.getPath());
                this.bildGroesseAendern(geladenesBild.width, geladenesBild.height);
                this.pg.beginDraw();
                this.pg.image(mal_o_mat_2_0.this.loadImage(file.getPath()), 0.0f, 0.0f);
                this.pg.endDraw();
                this.undoSpeicher.save();
            }
        }
    }

    abstract class FarbPinsel
    extends Pinsel {
        FarbPinsel() {
            this.cp5.addSlider("rot");
            this.cp5.addSlider("gruen");
            this.cp5.addSlider("blau");
        }

        @Override
        public void zeichnen() {
            super.zeichnen();
            this.pg.beginDraw();
            this.pg.stroke(this.cp5.getValue("rot"), this.cp5.getValue("gruen"), this.cp5.getValue("blau"));
            this.pg.endDraw();
        }
    }

    class LinienPinsel
    extends FarbPinsel {
        LinienPinsel() {
            this.label.setText(" LINIENPINSEL");
        }

        @Override
        public void zeichnen() {
            super.zeichnen();
            if (!this.pinselMalt()) {
                return;
            }
            this.pg.beginDraw();
            this.pg.strokeWeight(this.radius());
            this.pg.line((float)(mal_o_mat_2_0.this.pmouseX + this.dX), (float)(mal_o_mat_2_0.this.pmouseY + this.dY), (float)(mal_o_mat_2_0.this.mouseX + this.dX), (float)(mal_o_mat_2_0.this.mouseY + this.dY));
            this.pg.endDraw();
        }
    }

    abstract class Pinsel {
        ControlP5 cp5;
        PGraphics pg;
        int dX;
        int dY;
        Textlabel label;

        Pinsel() {
            this.cp5 = new ControlP5(mal_o_mat_2_0.this.app);
            this.cp5.setPosition(0, 140);
            this.cp5.setAutoAddDirection(1);
            this.cp5.setColorCaptionLabel(0);
            this.label = this.cp5.addTextlabel("label");
            this.label.setColorValue(-16777216);
            this.label.setFont(mal_o_mat_2_0.this.createFont("Arial", 15.0f));
            this.cp5.addSlider("radius", 0.1f, 1.0f).setValue(0.3f);
            this.cp5.setVisible(false);
            this.pg = mal_o_mat_2_0.this.bild.pg;
        }

        public float radius() {
            return 100.0f * mal_o_mat_2_0.pow((float)this.cp5.getValue("radius"), (float)3.0f);
        }

        public boolean pinselMalt() {
            return mal_o_mat_2_0.this.bild.wirdBearbeitet || mal_o_mat_2_0.this.vorschau.wirdBearbeitet;
        }

        public void zeichnen() {
            if (mal_o_mat_2_0.this.bild.mausImBild() && !mal_o_mat_2_0.this.vorschau.wirdBearbeitet) {
                mal_o_mat_2_0.this.bild.wirdBearbeitet = true;
                this.pg = mal_o_mat_2_0.this.bild.pg;
                this.dX = -mal_o_mat_2_0.this.dXBild;
                this.dY = -mal_o_mat_2_0.this.dYBild;
            } else if (mal_o_mat_2_0.this.vorschau.mausImBild() && !mal_o_mat_2_0.this.bild.wirdBearbeitet) {
                mal_o_mat_2_0.this.vorschau.wirdBearbeitet = true;
                this.pg = mal_o_mat_2_0.this.vorschau.pg;
                this.dX = -mal_o_mat_2_0.this.dXVorschau;
                this.dY = -mal_o_mat_2_0.this.dYVorschau;
            }
        }

        public void aktiv(boolean aktiv) {
            this.cp5.setVisible(aktiv);
        }
    }

    class PinselVorschau {
        PGraphics pg;
        boolean wirdBearbeitet = false;

        PinselVorschau() {
            this.pg = mal_o_mat_2_0.this.createGraphics(mal_o_mat_2_0.this.kontrollfeldBreite - 2 * mal_o_mat_2_0.this.randBreite, 100);
            this.pg.beginDraw();
            this.pg.colorMode(1, 100.0f);
            this.pg.background(100);
            this.pg.endDraw();
        }

        public void anzeigen() {
            mal_o_mat_2_0.this.image((PImage)this.pg, mal_o_mat_2_0.this.dXVorschau, mal_o_mat_2_0.this.dYVorschau);
        }

        public void malenBeenden() {
            this.wirdBearbeitet = false;
        }

        public boolean mausImBild() {
            return mal_o_mat_2_0.this.mouseX > mal_o_mat_2_0.this.dXVorschau && mal_o_mat_2_0.this.mouseX < mal_o_mat_2_0.this.vorschau.pg.width + mal_o_mat_2_0.this.dXVorschau && mal_o_mat_2_0.this.mouseY > mal_o_mat_2_0.this.dYVorschau && mal_o_mat_2_0.this.mouseY < mal_o_mat_2_0.this.dYVorschau + mal_o_mat_2_0.this.vorschau.pg.height;
        }
    }

    class RadierPinsel
    extends Pinsel {
        RadierPinsel() {
            this.label.setText("RADIERER");
        }

        @Override
        public void zeichnen() {
            super.zeichnen();
            if (!this.pinselMalt()) {
                return;
            }
            this.pg.beginDraw();
            this.pg.strokeWeight(this.radius());
            this.pg.stroke(100);
            this.pg.line((float)(mal_o_mat_2_0.this.mouseX + this.dX), (float)(mal_o_mat_2_0.this.mouseY + this.dY), (float)(mal_o_mat_2_0.this.pmouseX + this.dX), (float)(mal_o_mat_2_0.this.pmouseY + this.dY));
            this.pg.endDraw();
        }
    }

    class SpruehPinsel
    extends FarbPinsel {
        SpruehPinsel() {
            this.cp5.addSlider("dichte", 0.1f, 1.0f);
            this.label.setText(" SPR\u00dcHPINSEL");
        }

        @Override
        public void zeichnen() {
            super.zeichnen();
            if (!this.pinselMalt()) {
                return;
            }
            this.pg.beginDraw();
            int nPunkte = (int)(this.cp5.getValue("radius") * this.cp5.getValue("dichte") * 200.0f);
            int i = 0;
            while (i < nPunkte) {
                float r = mal_o_mat_2_0.pow((float)this.cp5.getValue("radius"), (float)3.0f) * 30.0f;
                float x = mal_o_mat_2_0.this.randomGaussian() * r;
                float y = mal_o_mat_2_0.this.randomGaussian() * r;
                this.pg.strokeWeight(0.5f);
                this.pg.point((float)mal_o_mat_2_0.this.mouseX + x + (float)this.dX, (float)mal_o_mat_2_0.this.mouseY + y + (float)this.dY);
                ++i;
            }
            this.pg.endDraw();
        }
    }

    class UndoSpeicher {
        LinkedList<PImage> img = new LinkedList();
        PImage aktuellesBild;
        static final int nBilder = 20;

        UndoSpeicher(Bild bild) {
            this.aktuellesBild = bild.pg.copy();
        }

        public void save() {
            this.img.add(this.aktuellesBild);
            this.aktuellesBild = mal_o_mat_2_0.this.bild.pg.copy();
            if (this.img.size() > 20) {
                this.img.pollFirst();
            }
        }

        public PImage undo() {
            if (!this.img.isEmpty()) {
                this.aktuellesBild = this.img.pollLast();
            }
            return this.aktuellesBild;
        }
    }
}

