/*
Mal-o-Mat is a painting software, written in Processing
2017 by Pit Noack for c't Magazine, issue 24/2017
Download fee-based article: <http://ct.de/ymqc>
The development of future versions will be documented here: <http://www.maschinennah.de/>
 
Mal-o-Mat is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.
 
Mal-o-Mat is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details:
<http://www.gnu.org/licenses/>
 
@author   Pit Noack <mail@pitnoack.de>
@modified 03/11/2017
@version  2.0
*/

import controlP5.*;

PApplet app = this;
ControlP5 cp5;

int kontrollfeldBreite = 180;
int randBreite = 5;

int dXBild = kontrollfeldBreite;
int dYBild = randBreite;
int dXVorschau = randBreite;
int dYVorschau = randBreite;

Pinsel aktuellerPinsel;
RadierPinsel radierPinsel;
LinienPinsel linienPinsel;
SpruehPinsel spruehPinsel;

Bild bild;
PinselVorschau vorschau;

void setup() {
  surface.setResizable(true);
  surface.setSize(300, 230);
  colorMode(RGB, 100);
  background(90);
  initStartKontrollelemente();
}

void draw() {
  background(90);
  if (bild == null) {
    return;
  }
  if (mousePressed) {
    aktuellerPinsel.zeichnen();
  }
  bild.anzeigen();
  vorschau.anzeigen();
  fill(0);
  textSize(11);
  text("Pinselvorschau", randBreite, 120);
  text("'m' --> Tastaturkürzel anzeigen", randBreite, height - 10);
}



void mouseReleased() {
  if (bild == null) {
    return;
  }
  if (bild.wirdBearbeitet == true) {
    bild.malenBeenden();
  }
  if (vorschau.wirdBearbeitet == true) {
    vorschau.malenBeenden();
  }
}

void keyPressed() {
  if (bild == null) {
    return;
  }
  loop();
  switch(key) {
  case '1':
    pinselWaehlen(linienPinsel);
    break;
  case '2':
    pinselWaehlen(spruehPinsel);
    break;
  case '0':
    pinselWaehlen(radierPinsel);
    break;
  case 'z':
    bild.undo();
    break;
  case 's':
    bild.speichern();
    break;
  case 'o':
    bild.oeffnen();
    break;
  case 'l':
    bild.loeschen();
    break;
  case 'r':
    reset();
    break;
  case 'm':
    noLoop();
    tastaturkuerzelAnzeigen();
    break;
  default:
    break;
  }
}