//Ein Pinsel, der wie eine Airbrushpistole funktioniert;
//Erbt von FarbPinsel
class SpruehPinsel extends FarbPinsel {
  
  //Konstruktor...
  SpruehPinsel() {
    //Der Superkonstruktor (also der Konstruktor von Pinsel) wird aufgerufen
    super();
    // Ein Slider zur Steuerung der Dichte der Farbpartikel wird hinzugefügt
    cp5.addSlider("dichte", 0.1, 1);
    //Der Name des Pinsels wird in das label geschrieben
    label.setText(" SPRÜHPINSEL");
  }

  //Wird von draw() aufgerufen
  void zeichnen() {
    //zeichnen() der Superklasse FarbPinsel wird aufgerufen.
    super.zeichnen();
    //Wenn der Pinsel nicht malt, wird abgebrochen.
    if ( !pinselMalt()) {
      return;
    }
    pg.beginDraw();
    //Die Anzahl der Farbpunkte wird abhängig von Radius und Dichte ermittelt.
    int nPunkte = (int) (cp5.getValue("radius") * cp5.getValue("dichte") * 200.0);
    
    //nPunkte steuert die Anzahl der Farbpunkte.
    for (int i = 0; i < nPunkte; ++i) {
      //Radius wird berechnet
      float r = pow(cp5.getValue("radius"), 3) * 30.0;
      //Zufällige x und y-Positionen eines Farbpunktes wird mit Gausscher Normalverteilung berechnet
      float x = randomGaussian() * r;
      float y = randomGaussian() * r;
      //Strichdicke wird gesetzt
      pg.strokeWeight(0.5);
      //Farbpunkt wird gemalt
      pg.point(mouseX + x + dX, mouseY + y + dY);
    }
    pg.endDraw();
  }
}