void initStartKontrollelemente() {
  cp5 = new ControlP5(this);

  cp5.setColorCaptionLabel(0);
  cp5.setFont(createFont("Arial", 12));
  cp5.setColorBackground(#FFFFFF);

  cp5.addTextlabel("label")
    .setPosition(70, 20)
    .setColorValue(#000000)
    .setFont(createFont("Arial", 20))
    .setText("c't Mal-o-Mat 2.0");

  cp5.addTextfield("breite")
    .setPosition(70, 60)
    .setSize(70, 30)
    .setColor(#000000)
    .setInputFilter(ControlP5.INTEGER)
    .setValue("640");

  cp5.addTextfield("hoehe")
    .setPosition(160, 60)
    .setSize(70, 30)
    .setColor(#000000)
    .setInputFilter(ControlP5.INTEGER)
    .setValue("480");

  cp5.addButton("initNeu")
    .setLabel("Neues Bild")
    .setPosition(70, 120)
    .setSize(160, 30)
    .setFont(createFont("Arial", 12));

  cp5.addButton("initMitBildDatei")
    .setLabel("Bild laden")
    .setPosition(70, 170)
    .setSize(160, 30)
    .setFont(createFont("Arial", 12));
}

public void initNeu() {
  initialisiere();
  aktualisiereFensterGroesse();
}

void initMitBildDatei() {
  initialisiere();
  bild.oeffnen();
}

void initialisiere() {
  cp5.setVisible(false);
  int breite = Integer.parseInt(((Textfield)(cp5.getController("breite"))).getText());
  int hoehe = Integer.parseInt(((Textfield)(cp5.getController("hoehe"))).getText());

  bild = new Bild(breite, hoehe);
  vorschau = new PinselVorschau();

  radierPinsel = new RadierPinsel();
  linienPinsel = new LinienPinsel();
  spruehPinsel = new SpruehPinsel();

  aktuellerPinsel = linienPinsel;
  aktuellerPinsel.aktiv(true);
}

void aktualisiereFensterGroesse() {
  int breite = kontrollfeldBreite + bild.pg.width + randBreite;
  int hoehe = bild.pg.height + 2 * randBreite;
  hoehe = constrain(hoehe, 480, MAX_INT);
  surface.setSize(breite, hoehe);
}

void reset() {
  aktuellerPinsel.aktiv(false);
  bild = null;
  surface.setSize(300, 230);
  cp5.setVisible(true);
}

void pinselWaehlen(Pinsel p) {
  aktuellerPinsel.aktiv(false);
  aktuellerPinsel = p;
  aktuellerPinsel.aktiv(true);
}

void textAnzeigen(String text) {
  int textKastenBreite = (int) (bild.pg.width - 2 * randBreite);
  int textKastenHoehe = (int) (height - 4 * randBreite);
  int x = dXBild + (bild.pg.width / 2) - (textKastenBreite / 2);
  int y = (height / 2) - (textKastenHoehe / 2);
  fill(95, 80);
  noStroke();
  rect(x, y, textKastenBreite, textKastenHoehe);
  float textGroesse = (textKastenBreite * textKastenHoehe) / text.length() / 50.0;
  textGroesse = constrain(textGroesse, 10, 25);
  PFont myFont = createFont("Arial", textGroesse);
  fill(0);
  textFont(myFont);
  text(text, x + randBreite, y + randBreite, textKastenBreite, textKastenHoehe);
}

void tastaturkuerzelAnzeigen() {
  textAnzeigen(
    "Tastaturkürzel\n"
    + "0      --> Radierer\n"
    + "1-9   --> Pinsel auswählen\n"
    + "o      --> Bild öffnen\n"
    + "s      --> Bild speichern\n"
    + "z      --> Undo\n"
    + "l       --> Löschen\n"
    + "r       --> Reset\n"
    + "m     --> Tastaturkürzel anzeigen\n\n"
    + "Anzeige schließen mit beliebiger Taste");
}