//Wird in setup() aufgerufen;
//Sorgt für die Bereitstellung der Kontrollelemente im Startfenster;
//Stößt über die Knöpfe "Neues Bild" und "Bild laden" alle weiteren Initialisierungen bis zum Öffnen des Hauptfensters an
void initStartKontrollelemente() {
  
  //ControlP5-Instanz für den Startbildschirm wird initialisiert
  cp5 = new ControlP5(this);

  //Beschriftung der Kontrollelemente ist schwarz
  cp5.setColorCaptionLabel(0);
  //Schrifttyp und Schriftgröße wird gesetzt
  cp5.setFont(createFont("Arial", 12));
  //Hintergrundfarbe ist weiß
  cp5.setColorBackground(#FFFFFF);

  //Label für den Programmnamen
  cp5.addTextlabel("label")
    //Position des Labels
    .setPosition(70, 20)
    //Hintergrundfarbe ist weiß
    .setColorValue(#000000)
    //Schrifttyp und Schriftgröße wird gesetzt
    .setFont(createFont("Arial", 20))
    //Programmname wird in das Label geschrieben
    .setText("c't Mal-o-Mat 2.0");

  //Textfeld für die Eingabe der Breite des Bildes in Pixeln
  cp5.addTextfield("breite")
    //Position des Textfeldes
    .setPosition(70, 60)
    //Größe des Textfeldes
    .setSize(70, 30)
    //Hintergrundfarbe ist weiß
    .setColor(#000000)
    //Es dürfen nur ganze Zahlen eingegeben werden
    .setInputFilter(ControlP5.INTEGER)
    //Wert des Textfeldes wird initialisiert
    .setValue("640");
  
  //Textfeld für die Eingabe der Höhe des Bildes in Pixel;
  //Analog zu Textfeld "hoehe"
  cp5.addTextfield("hoehe")
    .setPosition(160, 60)
    .setSize(70, 30)
    .setColor(#000000)
    .setInputFilter(ControlP5.INTEGER)
    .setValue("480");

  //Knopf zum Öffnen eines neuen Bildes
  cp5.addButton("initNeu")
     //Beschriftung des Knopfes
    .setLabel("Neues Bild")
    .setPosition(70, 120)
    .setSize(160, 30)
    .setFont(createFont("Arial", 12));

  //Knopf zum Öffnen eines gespeicherten Bildes...
  cp5.addButton("initMitBildDatei")
    .setLabel("Bild laden")
    .setPosition(70, 170)
    .setSize(160, 30)
    .setFont(createFont("Arial", 12));
}

//Wird aufgerufen, wenn der Knopf "Neues Bild" gedrückt wurde;
//Die dann aufgerufenen Funktionen stehen weiter unten.
public void initNeu() {
  initialisiere();
  aktualisiereFensterGroesse();
}

//Wird aufgerufen, wenn der Knopf "Bild laden" gedrückt wurde;
//initialisiere() steht weiter unten
void initMitBildDatei() {
  initialisiere();
  //Öffnet das Dialogfenster zum Öffnen des Bildes
  bild.oeffnen();
}

//Erledigt alle Initialisierungsschritte, die in jedem Fall (Neues Bild oder Bild laden) passieren müssen
void initialisiere() {
  //Die Kontrollelemente des Startfensters werden unsichtbar geschaltet.
  cp5.setVisible(false);
  
  //Die Größe des Bildes wird abhängig von den Zuständen der Textfelder im Startfenster gesetzt.
  //Integer.parseInt() dient der Umwandlung des Strings im Textfeldes in eine ganze Zahl.
  int breite = Integer.parseInt(((Textfield)(cp5.getController("breite"))).getText());
  int hoehe = Integer.parseInt(((Textfield)(cp5.getController("hoehe"))).getText());

  //Bild und PinselVorschau werden initialisert
  bild = new Bild(breite, hoehe);
  vorschau = new PinselVorschau();

  //Alle zur Verfügung stehenden Pinsel werden initialisert
  radierPinsel = new RadierPinsel();
  linienPinsel = new LinienPinsel();
  spruehPinsel = new SpruehPinsel();

  //Der LinienPinsel wird gewählt.
  //Er wird aktiv geschaltet, d.h. seine Kontrollemelemente sind sichtbar.
  aktuellerPinsel = linienPinsel;
  aktuellerPinsel.aktiv(true);
}

//Wird aufgerufen, wenn die Bildgröße sich geändert haben kann;
//Setzt die Größe des Hauptfensters so, dass das Bild vollständig hineinpasst
void aktualisiereFensterGroesse() {
  int breite = kontrollfeldBreite + bild.pg.width + randBreite;
  int hoehe = bild.pg.height + 2 * randBreite;
  hoehe = constrain(hoehe, 480, MAX_INT);
  surface.setSize(breite, hoehe);
}

//Wird von keyPressed() aufgerufen
void pinselWaehlen(Pinsel p) {
  //Deaktiviert den zuletzt gewählten Pinsel (d.h. schaltet die Kontrollelemente unsichtbar)
  aktuellerPinsel.aktiv(false);
  //Setzt den neu gewählten Pinsel als aktuellerPinsel
  aktuellerPinsel = p;
  //Aktiviert den neu gewählten Pinsel (d.h. schaltet die Kontrollelemente sichtbar)
  aktuellerPinsel.aktiv(true);
}

//Wird von keyPressed() aufgerufen, wenn "r" gedrückt wurde;
//Öffnet erneut das Startfenster
void reset() {
  //Deaktiviert den zuletzt gewählten Pinsel (d.h. schaltet die Kontrollelemente unsichtbar)
  aktuellerPinsel.aktiv(false);
  //Bild wird deinitialisiert
  //draw(), keyPressed() und mouseReleased() brechen ab, wenn bild gleich null ist
  bild = null;
  //Fenstergröße wird auf die Größe des Startfensters gesetzt
  surface.setSize(300, 230);
  //Kontrollelemente des Startbildschirms sind sichtbar
  cp5.setVisible(true);
}

//Zeigt Texte an, wird ausschliesslich für die Anzeige der Tastaturkürzel benötigt;
//TODO: Neu schreiben, ist etwas unübersichtlich;
//Problem: Bei sehr kleinen oder sehr großen Bildern sieht die Anzeige nicht schick aus, Schrift ist evtl. nicht lesbar oder zu groß.
void textAnzeigen(String text) {
  int textKastenBreite = (int) (bild.pg.width - 2 * randBreite);
  int textKastenHoehe = (int) (height - 4 * randBreite);
  int x = dXBild + (bild.pg.width / 2) - (textKastenBreite / 2);
  int y = (height / 2) - (textKastenHoehe / 2);
  fill(95, 80);
  noStroke();
  rect(x, y, textKastenBreite, textKastenHoehe);
  float textGroesse = (textKastenBreite * textKastenHoehe) / text.length() / 50.0;
  textGroesse = constrain(textGroesse, 10, 25);
  PFont myFont = createFont("Arial", textGroesse);
  fill(0);
  textFont(myFont);
  text(text, x + randBreite, y + randBreite, textKastenBreite, textKastenHoehe);
}

//Anzeige der Tastaturkürzel
void tastaturkuerzelAnzeigen() {
  textAnzeigen(
    "Tastaturkürzel\n"
    + "0      --> Radierer\n"
    + "1-9   --> Pinsel auswählen\n"
    + "o      --> Bild öffnen\n"
    + "s      --> Bild speichern\n"
    + "z      --> Undo\n"
    + "l       --> Löschen\n"
    + "r       --> Reset\n"
    + "m     --> Tastaturkürzel anzeigen\n\n"
    + "Anzeige schließen mit beliebiger Taste");
}