##!/usr/bin/env python
# -*- coding: utf-8 -*-
#Dieses Skript ist ein einfaches Beispiel für die direkte Verarbeitung der Codes, ohne sie in der Bridge einzulernen. Das Skript gibt die empfangenen Codes aus und kann Aktionen auslösen, 
#wenn die Adresse passt oder ein bestimmter Tag/eine bestimmte Uhrzeit ist.

#Dieses Skript benötigt Paho MQTT. Installieren Sie die Bibliothek mit dem Befehl "pip install paho-mqtt"!
import paho.mqtt.client as mqtt
from time import sleep
import time
import datetime

#Ihr MQTT-Server:
mqtt_server = "192.168.1.1"
mqtt_port = 1883
#Hier muss nur der Root-Topic des  
mqtt_topic = "rf"
true = 1
oldtime = "0"

#Diese Funktion filtert die statische Geräteadresse aus der Nachricht
def addressformat(msg):
	try:
		rfrawdata = list(msg)
		rfrawdata = rfrawdata[13] + rfrawdata[14] + rfrawdata[15] + rfrawdata[16] + rfrawdata[17]		
		return rfrawdata
	except:
		rfrawdata = ""
		return rfrawdata

#Hier wird Tag und Zeit ermittelt
def timeformat():
	global oldtime
	global newtime
	ts = time.time()
	hourminutetime = datetime.datetime.fromtimestamp(ts).strftime('%H:%M')
	if oldtime != hourminutetime:
		oldtime = hourminutetime
		newtime = 1
	elif oldtime == hourminutetime:
		newtime = 0
	
	day = datetime.datetime.today().strftime("%A")
	return day,hourminutetime

def on_connect(client, userdata, flags, rc):
	if rc == 0:
		print("Verbindung zum Server erfolgreich hergestellt\n")
		client.subscribe(mqtt_topic + "/rfin")
	elif rc == 1:
		print("Verbindung abgelehnt: Protokollversion ungültig")
	elif rc == 2:
		print("Verbindung abgelehnt: Identifier abgelehnt")
	elif rc == 3:
		print("Verbindung abgelehnt: Server ausgelastet")
	elif rc == 4:
		print("Verbindung abgelehnt: Benutzername oder Passwort falsch")
	elif rc == 5:
		print("Verbindung abgelehnt: Nicht autorisiert")

#Paho ruft diese Funktion auf, sobald eine Nachricht im rfin-Topic erscheint. Hier beginnt die Verarbeitung eines Datenpakets.
#Es wird zunächst an addressformat() geschickt, um die statische Adresse zu ermitteln. Anschließend reicht eine simple If-
#Bedingung, um Aktionen auszulösen (z.B. den Versand, mehrerer RF-Codes für Funksteckdosen) 

def on_message(client, userdata, msg):
 	rfinput = msg.payload
	print("Empfangene gesamte Nachricht: " + rfinput)
	address = addressformat(rfinput)
	print("Geräteadresse: " + address)

	if address == "F09E2":
		dreisteckdosen()
		print("\n")
	else:
		print("Keine Aktion mit dieser Adresse verknüpft\n")

#Diese Funktion vereinfacht den Versand von RF-Codes. Der Sendcounter definiert, wie oft ein Code gesendet wird.
#Wenn Ihre Schaltaktoren gelegentlich Empfangsprobleme haben, kann es helfen, die Anzahl der Sendedurchläfe zu erhöhen.
def rfout(rfoutdata):
	sendcounter = "4"
	rfoutdata = rfoutdata + "," + sendcounter
	client.publish(mqtt_topic + "/rfout/set", payload=rfoutdata, qos=0, retain=False)

#Diese Funktion sendet drei Codes. Hier versendet man die gesamte Nachricht (siehe Skriptausgabe beim Empfang von Codes)
def dreisteckdosen():
	print("Sende Code für Steckdose 1, 2 und 3")
	rfout("1F0400FA03024F12C5")
	rfout("1F0400FA03024A19F7")
	rfout("1F0400FA03024B63C9")
	
client = mqtt.Client()
client.on_connect = on_connect
client.on_message = on_message

client.connect(mqtt_server, mqtt_port, 60)

#Die ewige Schleife, die das Skript am Laufen hält.
while true:
	client.loop(0.05)
	day, hourminutetime = timeformat()
	
	#Diese Prüfung ist wichtig, da die Schleife nicht einmal pro Minute durchläuft, sondern wesentlich öfter.
	#Ohne sie werden die Funktionen hunderte Male ausgeführt, wenn die Zeit passt.
	#newtime steht beim ersten Durchlauf auf 1, sodass die Funktionen ausgeführt werden, danach bis zur 
	#nächsten vollen Minute auf 0.
	if newtime == 1:
		print("Zeit: " + hourminutetime + "\nTag: " + day)

		#Hier passiert etwas zu einer bestimmten Zeit (z.B. 14:10 Uhr), jeden Tag.
		if hourminutetime == "14:10":
			print("Es ist 14:10 Uhr. Steckdosen werden eingeschaltet")
			dreisteckdosen()
			
		#Hier wird nur Montags um 14:40 Uhr geschaltet.
		if hourminutetime == "15:03" and day == "Monday":
			dreisteckdosen()
