/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.openmuc.jsml.structures.ASNObject;

public class Integer16
extends ASNObject {
    protected short val;

    public Integer16() {
    }

    public Integer16(short i) {
        this.val = i;
        this.isSelected = true;
    }

    public short getVal() {
        return this.val;
    }

    @Override
    public void encode(DataOutputStream os) throws IOException {
        if (this.isOptional && !this.isSelected) {
            os.writeByte(1);
            return;
        }
        os.writeByte(83);
        os.writeShort(this.val);
    }

    @Override
    public boolean decode(DataInputStream is) throws IOException {
        byte typeLengthField = is.readByte();
        if (this.isOptional && typeLengthField == 1) {
            this.isSelected = false;
            return true;
        }
        if ((typeLengthField & 0x50) != 80) {
            return false;
        }
        int length = (typeLengthField & 0xF) - 1;
        this.val = 0;
        int j = length - 1;
        while (j >= 0) {
            this.val = (short)(this.val | (is.readByte() & 0xFF) << 8 * j);
            --j;
        }
        if ((this.val >> 8 * (length - 1) & 0x80) == 128) {
            int i = 2;
            while (i > length) {
                this.val = (short)(this.val | 255 << 8 * (i - 1));
                --i;
            }
        }
        this.isSelected = true;
        return true;
    }

    public String toString() {
        return String.valueOf(this.val);
    }
}

