/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.openmuc.jsml.structures.ASNObject;

public class Unsigned64
extends ASNObject {
    protected long val;

    public Unsigned64() {
    }

    public Unsigned64(long i) {
        this.setVal(i);
    }

    @Override
    public void encode(DataOutputStream os) throws IOException {
        if (this.isOptional && !this.isSelected) {
            os.writeByte(1);
            return;
        }
        os.writeByte(105);
        os.writeLong(this.val & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean decode(DataInputStream is) throws IOException {
        byte typeLengthField = is.readByte();
        if (this.isOptional && typeLengthField == 1) {
            this.isSelected = false;
            return true;
        }
        if ((typeLengthField & 0x60) != 96) {
            return false;
        }
        int length = (typeLengthField & 0xF) - 1;
        --length;
        while (length >= 0) {
            this.val |= (long)(is.readByte() & 0xFF) << 8 * length;
            --length;
        }
        this.isSelected = true;
        return true;
    }

    public String toString() {
        return String.valueOf(this.val);
    }

    public long getVal() {
        return this.val;
    }

    public void setVal(long i) {
        this.val = i & 0xFFFFFFFFFFFFFFFFL;
        this.isSelected = true;
    }
}

