/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.openmuc.jsml.structures.ASNObject;

public class OctetString
extends ASNObject {
    private static final int MAX_LENGTH = 32000;
    protected byte[] value;

    public OctetString() {
    }

    public OctetString(byte[] octetString) {
        this.set(octetString);
        this.isSelected = true;
    }

    public OctetString(String octetString) {
        this(OctetString.toArray(octetString));
    }

    public byte[] getValue() {
        return this.value;
    }

    public void set(byte[] octetString) {
        if (octetString != null) {
            if (octetString.length < 32000) {
                this.value = octetString;
            }
        } else {
            this.value = new byte[0];
        }
    }

    @Override
    public void encode(DataOutputStream os) throws IOException {
        if (this.isOptional && !this.isSelected) {
            os.writeByte(1);
            return;
        }
        int numTlField = 1;
        while (Math.pow(2.0, 4 * numTlField) - 1.0 - (double)numTlField < (double)this.value.length) {
            ++numTlField;
        }
        int i = numTlField;
        while (i > 0) {
            int firstFourBits = 0;
            if (i > 1) {
                firstFourBits = 128;
            }
            os.writeByte(firstFourBits & 0xFF | this.value.length + numTlField >> (i - 1) * 4 & 0xF);
            --i;
        }
        byte[] byArray = this.value;
        int n = this.value.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            os.write(element);
            ++n2;
        }
    }

    @Override
    public boolean decode(DataInputStream is) throws IOException {
        int tlLength = 1;
        byte typeLength = is.readByte();
        if (this.isOptional && typeLength == 1) {
            this.isSelected = false;
            return true;
        }
        if ((typeLength & 0x70) >> 4 != 0) {
            return false;
        }
        int length = typeLength & 0xF;
        while ((typeLength & 0x80) == 128) {
            ++tlLength;
            typeLength = is.readByte();
            if ((typeLength & 0x70) >> 4 != 0) {
                return false;
            }
            length = (length & 0xFFFFFFFF) << 4 | typeLength & 0xF;
        }
        this.value = new byte[length -= tlLength];
        int i = 0;
        while (i < length) {
            this.value[i] = is.readByte();
            ++i;
        }
        this.isSelected = true;
        return true;
    }

    public byte[] toBytes() {
        return this.value;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof OctetString) {
            return Arrays.equals(this.value, ((OctetString)other).toBytes());
        }
        return false;
    }

    public String toString() {
        if (this.value == null) {
            return new String("not set");
        }
        return this.toHexString();
    }

    public String toDecimalString() {
        StringBuilder asBytes = new StringBuilder();
        int i = 0;
        while (i < this.value.length - 1) {
            asBytes.append(this.value[i] & 0xFF).append(".");
            ++i;
        }
        asBytes.append(this.value[this.value.length - 1] & 0xFF);
        return asBytes.toString();
    }

    public String toHexString() {
        StringBuilder asBytes = new StringBuilder();
        byte[] byArray = this.value;
        int n = this.value.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            asBytes.append(String.format("%02X ", element));
            ++n2;
        }
        return asBytes.toString().trim();
    }

    public static byte[] toArray(String octetString) {
        if (octetString != null) {
            int ln = octetString.length();
            if (ln > 2 && (ln & 1) == 0 && octetString.startsWith("0x")) {
                byte[] buf = new byte[(ln >> 1) - 1];
                int i = 2;
                while (i < ln) {
                    buf[(i >> 1) - 1] = (byte)((Character.digit(octetString.charAt(i), 16) << 4) + Character.digit(octetString.charAt(i + 1), 16));
                    i += 2;
                }
                return buf;
            }
            return octetString.getBytes();
        }
        return new byte[0];
    }
}

