/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.EMessageBody;
import org.openmuc.jsml.structures.Unsigned32;
import org.openmuc.jsml.structures.requests.SmlGetListReq;
import org.openmuc.jsml.structures.requests.SmlGetProcParameterReq;
import org.openmuc.jsml.structures.requests.SmlGetProfileListReq;
import org.openmuc.jsml.structures.requests.SmlGetProfilePackReq;
import org.openmuc.jsml.structures.requests.SmlPublicCloseReq;
import org.openmuc.jsml.structures.requests.SmlPublicOpenReq;
import org.openmuc.jsml.structures.requests.SmlSetProcParameterReq;
import org.openmuc.jsml.structures.responses.SmlAttentionRes;
import org.openmuc.jsml.structures.responses.SmlGetListRes;
import org.openmuc.jsml.structures.responses.SmlGetProcParameterRes;
import org.openmuc.jsml.structures.responses.SmlGetProfileListRes;
import org.openmuc.jsml.structures.responses.SmlGetProfilePackRes;
import org.openmuc.jsml.structures.responses.SmlPublicCloseRes;
import org.openmuc.jsml.structures.responses.SmlPublicOpenRes;

public class SmlMessageBody
extends ASNObject {
    protected Unsigned32 tag;
    protected ASNObject choice;

    public SmlMessageBody(int tag, ASNObject choice) {
        EMessageBody messageBody = EMessageBody.toEnum(tag);
        this.choice = choice;
        this.tag = new Unsigned32(messageBody.id());
        this.isSelected = true;
    }

    public SmlMessageBody() {
        this.tag = new Unsigned32();
    }

    @Override
    public void encode(DataOutputStream os) throws IOException {
        if (this.isOptional && !this.isSelected) {
            os.writeByte(1);
            return;
        }
        os.writeByte(114);
        this.tag.encode(os);
        this.choice.encode(os);
    }

    @Override
    public boolean decode(DataInputStream is) throws IOException {
        byte tlField = is.readByte();
        if (this.isOptional && tlField == 1) {
            this.isSelected = false;
            return true;
        }
        if ((tlField & 0xFF) != 114 || !this.tag.decode(is)) {
            return false;
        }
        EMessageBody messageBody = EMessageBody.toEnum(this.tag.val);
        switch (messageBody) {
            case OPEN_REQUEST: {
                this.choice = new SmlPublicOpenReq();
                break;
            }
            case OPEN_RESPONSE: {
                this.choice = new SmlPublicOpenRes();
                break;
            }
            case CLOSE_REQUEST: {
                this.choice = new SmlPublicCloseReq();
                break;
            }
            case CLOSE_RESPONSE: {
                this.choice = new SmlPublicCloseRes();
                break;
            }
            case GET_PROFILE_LIST_REQUEST: {
                this.choice = new SmlGetProfileListReq();
                break;
            }
            case GET_PROFILE_LIST_RESPONSE: {
                this.choice = new SmlGetProfileListRes();
                break;
            }
            case GET_PROFILE_PACK_REQUEST: {
                this.choice = new SmlGetProfilePackReq();
                break;
            }
            case GET_PROFILE_PACK_RESPONSE: {
                this.choice = new SmlGetProfilePackRes();
                break;
            }
            case GET_PROC_PARAMETER_REQUEST: {
                this.choice = new SmlGetProcParameterReq();
                break;
            }
            case GET_PROC_PARAMETER_RESPONSE: {
                this.choice = new SmlGetProcParameterRes();
                break;
            }
            case SET_PROC_PARAMETER_REQUEST: {
                this.choice = new SmlSetProcParameterReq();
                break;
            }
            case GET_LIST_REQUEST: {
                this.choice = new SmlGetListReq();
                break;
            }
            case GET_LIST_RESPONSE: {
                this.choice = new SmlGetListRes();
                break;
            }
            case ATTENTION_RESPONSE: {
                this.choice = new SmlAttentionRes();
                break;
            }
            default: {
                return false;
            }
        }
        if (!this.choice.decode(is)) {
            return false;
        }
        this.isSelected = true;
        return true;
    }

    public Unsigned32 getTag() {
        return this.tag;
    }

    public ASNObject getChoice() {
        return this.choice;
    }
}

