/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures;

import org.openmuc.jsml.EObis;
import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.Integer8;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.Sequence;
import org.openmuc.jsml.structures.SmlSignature;
import org.openmuc.jsml.structures.SmlUnit;
import org.openmuc.jsml.structures.SmlValue;

public class SmlPeriodEntry
extends Sequence {
    protected OctetString objName;
    protected SmlUnit unit;
    protected Integer8 scaler;
    protected SmlValue value;
    protected SmlSignature valueSignature;

    public OctetString getObjName() {
        return this.objName;
    }

    public SmlUnit getUnit() {
        return this.unit;
    }

    public Integer8 getScaler() {
        return this.scaler;
    }

    public SmlValue getValue() {
        return this.value;
    }

    public SmlSignature getValueSignature() {
        return this.valueSignature;
    }

    public void setObjName(OctetString objName) {
        this.objName = objName;
    }

    public void setUnit(SmlUnit unit) {
        this.unit = unit;
    }

    public void setScaler(Integer8 scaler) {
        this.scaler = scaler;
    }

    public void setValue(SmlValue value) {
        this.value = value;
    }

    public void setValueSignature(SmlSignature valueSignature) {
        this.valueSignature = valueSignature;
    }

    public SmlPeriodEntry(OctetString objName, SmlUnit unit, Integer8 scaler, SmlValue value, SmlSignature valueSignature) {
        this.objName = objName;
        this.unit = unit;
        this.scaler = scaler;
        this.value = value;
        this.valueSignature = valueSignature;
        if (this.valueSignature == null) {
            this.valueSignature = new SmlSignature();
        }
        this.setOptionalAndSeq();
        this.isSelected = true;
    }

    public SmlPeriodEntry() {
    }

    public void setOptionalAndSeq() {
        this.valueSignature.setOptional();
        this.seqArray = new ASNObject[]{this.objName, this.unit, this.scaler, this.value, this.valueSignature};
    }

    @Override
    protected void createElements() {
        this.objName = new OctetString();
        this.unit = new SmlUnit();
        this.scaler = new Integer8();
        this.value = new SmlValue();
        this.valueSignature = new SmlSignature();
        this.setOptionalAndSeq();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n    SML_PeriodEntry{\n");
        sb.append("      objName:         " + (Object)((Object)EObis.getInstance(this.objName)) + " " + this.objName.toString() + "\n");
        sb.append("      unit:            " + this.unit.toString() + "\n");
        sb.append("      scaler:          " + this.scaler.toString() + "\n");
        sb.append("      value:           " + this.value.toString() + "\n");
        sb.append("      valueSignature:  " + this.valueSignature.toString() + "\n");
        sb.append("}\n");
        return sb.toString();
    }
}

