/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures.requests;

import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.Sequence;
import org.openmuc.jsml.structures.SmlTreePath;

public class SmlGetProcParameterReq
extends Sequence {
    protected OctetString serverId;
    protected OctetString username;
    protected OctetString password;
    protected SmlTreePath parameterTreePath;
    protected OctetString attribute;

    public SmlGetProcParameterReq() {
    }

    public SmlGetProcParameterReq(OctetString serverId, OctetString username, OctetString password, SmlTreePath parameterTreePath, OctetString attribute) {
        if (parameterTreePath == null) {
            throw new IllegalArgumentException("SML_GetProcParameterReq: parameterTreePath is not optional and must not be null!");
        }
        this.serverId = serverId;
        this.username = username;
        this.password = password;
        this.parameterTreePath = parameterTreePath;
        this.attribute = attribute;
        if (this.serverId == null) {
            this.serverId = new OctetString();
        }
        if (this.username == null) {
            this.username = new OctetString();
        }
        if (this.password == null) {
            this.password = new OctetString();
        }
        if (this.attribute == null) {
            this.attribute = new OctetString();
        }
        this.setOptionalAndSeq();
        this.isSelected = true;
    }

    public OctetString getServerId() {
        return this.serverId;
    }

    public OctetString getUsername() {
        return this.username;
    }

    public OctetString getPassword() {
        return this.password;
    }

    public SmlTreePath getParameterTreePath() {
        return this.parameterTreePath;
    }

    public OctetString getAttribute() {
        return this.attribute;
    }

    public void setOptionalAndSeq() {
        this.serverId.setOptional();
        this.username.setOptional();
        this.password.setOptional();
        this.attribute.setOptional();
        this.seqArray = new ASNObject[]{this.serverId, this.username, this.password, this.parameterTreePath, this.attribute};
    }

    @Override
    protected void createElements() {
        this.serverId = new OctetString();
        this.username = new OctetString();
        this.password = new OctetString();
        this.parameterTreePath = new SmlTreePath();
        this.attribute = new OctetString();
        this.setOptionalAndSeq();
    }
}

