/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jsml.structures.requests;

import org.openmuc.jsml.structures.ASNObject;
import org.openmuc.jsml.structures.ListOfSmlObjReqEntry;
import org.openmuc.jsml.structures.OctetString;
import org.openmuc.jsml.structures.Sequence;
import org.openmuc.jsml.structures.SmlBoolean;
import org.openmuc.jsml.structures.SmlTime;
import org.openmuc.jsml.structures.SmlTree;
import org.openmuc.jsml.structures.SmlTreePath;

public class SmlGetProfilePackReq
extends Sequence {
    protected OctetString serverId;
    protected OctetString username;
    protected OctetString password;
    protected SmlBoolean withRawdata;
    protected SmlTime beginTime;
    protected SmlTime endTime;
    protected SmlTreePath parameterTreePath;
    protected ListOfSmlObjReqEntry objectList;
    protected SmlTree dasDetails;

    public SmlGetProfilePackReq() {
    }

    public SmlGetProfilePackReq(OctetString serverId, OctetString username, OctetString password, SmlBoolean withRawdata, SmlTime beginTime, SmlTime endTime, SmlTreePath parameterTreePath, ListOfSmlObjReqEntry objectList, SmlTree dasDetails) {
        if (parameterTreePath == null) {
            throw new IllegalArgumentException("SML_GetProfilePackReq: parameterTreePath is not optional and must not be null!");
        }
        this.serverId = serverId;
        this.username = username;
        this.password = password;
        this.withRawdata = withRawdata;
        this.beginTime = beginTime;
        this.endTime = endTime;
        this.parameterTreePath = parameterTreePath;
        this.objectList = objectList;
        this.dasDetails = dasDetails;
        if (this.serverId == null) {
            this.serverId = new OctetString();
        }
        if (this.username == null) {
            this.username = new OctetString();
        }
        if (this.password == null) {
            this.password = new OctetString();
        }
        if (this.withRawdata == null) {
            this.withRawdata = new SmlBoolean();
        }
        if (this.beginTime == null) {
            this.beginTime = new SmlTime();
        }
        if (this.endTime == null) {
            this.endTime = new SmlTime();
        }
        if (this.objectList == null) {
            this.objectList = new ListOfSmlObjReqEntry();
        }
        if (this.dasDetails == null) {
            this.dasDetails = new SmlTree();
        }
        this.setOptionalAndSeq();
        this.isSelected = true;
    }

    public OctetString getServerId() {
        return this.serverId;
    }

    public OctetString getUsername() {
        return this.username;
    }

    public OctetString getPassword() {
        return this.password;
    }

    public SmlBoolean getWithRawdata() {
        return this.withRawdata;
    }

    public SmlTime getBeginTime() {
        return this.beginTime;
    }

    public SmlTime getEndTime() {
        return this.endTime;
    }

    public SmlTreePath getParameterTreePath() {
        return this.parameterTreePath;
    }

    public ListOfSmlObjReqEntry getObjectList() {
        return this.objectList;
    }

    public SmlTree getDasDetails() {
        return this.dasDetails;
    }

    public void setOptionalAndSeq() {
        this.serverId.setOptional();
        this.username.setOptional();
        this.password.setOptional();
        this.withRawdata.setOptional();
        this.beginTime.setOptional();
        this.endTime.setOptional();
        this.objectList.setOptional();
        this.dasDetails.setOptional();
        this.seqArray = new ASNObject[]{this.serverId, this.username, this.password, this.withRawdata, this.beginTime, this.endTime, this.parameterTreePath, this.objectList, this.dasDetails};
    }

    @Override
    protected void createElements() {
        this.serverId = new OctetString();
        this.username = new OctetString();
        this.password = new OctetString();
        this.withRawdata = new SmlBoolean();
        this.beginTime = new SmlTime();
        this.endTime = new SmlTime();
        this.parameterTreePath = new SmlTreePath();
        this.objectList = new ListOfSmlObjReqEntry();
        this.dasDetails = new SmlTree();
        this.setOptionalAndSeq();
    }
}

