/*
 * Decompiled with CFR 0.152.
 */
package co.gongzh.procbridge;

import co.gongzh.procbridge.APIHandler;
import co.gongzh.procbridge.ProcBridgeServer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

final class ReflectiveDelegate
implements ProcBridgeServer.Delegate {
    @NotNull
    private final Object target;
    @NotNull
    private final Map<String, Method> apiMap;

    ReflectiveDelegate(@NotNull Object target) {
        this.target = target;
        this.apiMap = new HashMap<String, Method>();
        for (Method m : target.getClass().getDeclaredMethods()) {
            if (m.getAnnotation(APIHandler.class) == null) continue;
            String api = m.getName();
            if (this.apiMap.containsKey(api)) {
                throw new RuntimeException("duplicate api: " + api);
            }
            if (m.getParameterCount() == 1) {
                Class<?> cl = m.getParameterTypes()[0];
                if (cl != JSONObject.class) {
                    throw new RuntimeException("parameter is not a JSON object for api: " + api);
                }
            } else if (m.getParameterCount() > 1) {
                throw new RuntimeException("too many parameters for api: " + api);
            }
            if (m.getReturnType() != JSONObject.class && m.getReturnType() != String.class && m.getReturnType() != Void.TYPE) {
                throw new RuntimeException("return type is not a JSON object/text for api: " + api);
            }
            m.setAccessible(true);
            this.apiMap.put(api, m);
        }
    }

    @Override
    @Nullable
    public JSONObject handleRequest(@NotNull String api, @NotNull JSONObject body) throws Exception {
        Method m = this.apiMap.get(api);
        if (m == null) {
            throw new RuntimeException("unknown api: " + api);
        }
        Object ret = m.getParameterCount() == 1 ? m.invoke(this.target, body) : m.invoke(this.target, new Object[0]);
        if (ret instanceof JSONObject) {
            return (JSONObject)ret;
        }
        if (ret instanceof String) {
            String jsonText = (String)ret;
            return new JSONObject(jsonText);
        }
        return null;
    }
}

