/*
 * Decompiled with CFR 0.152.
 */
package co.gongzh.procbridge;

import co.gongzh.procbridge.BadResponseEncoder;
import co.gongzh.procbridge.Encoder;
import co.gongzh.procbridge.GoodResponseEncoder;
import co.gongzh.procbridge.ProcBridgeException;
import co.gongzh.procbridge.Protocol;
import co.gongzh.procbridge.ReflectiveDelegate;
import co.gongzh.procbridge.RequestDecoder;
import co.gongzh.procbridge.TimeGuard;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

public final class ProcBridgeServer {
    private final int port;
    private final Delegate delegate;
    private boolean started = false;
    private long timeout;
    private ExecutorService executor;
    private ServerSocket serverSocket;

    public ProcBridgeServer(int port, long timeout, @NotNull Object delegate) {
        this(port, timeout, new ReflectiveDelegate(delegate));
    }

    public ProcBridgeServer(int port, long timeout, Delegate delegate) {
        this.port = port;
        this.delegate = delegate;
        this.timeout = timeout;
        this.executor = null;
        this.serverSocket = null;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public int getPort() {
        return this.port;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public synchronized void start() throws IOException {
        ExecutorService executor;
        ServerSocket serverSocket;
        if (this.started) {
            throw new IllegalStateException("server already started");
        }
        this.serverSocket = serverSocket = new ServerSocket(this.port);
        this.executor = executor = Executors.newCachedThreadPool();
        executor.execute(() -> {
            try {
                while (true) {
                    Socket socket = serverSocket.accept();
                    Connection conn = new Connection(socket, this.timeout, executor, this.delegate);
                    ProcBridgeServer procBridgeServer = this;
                    synchronized (procBridgeServer) {
                        if (!this.started) {
                            return;
                        }
                        executor.execute(conn);
                    }
                }
            }
            catch (IOException ignored) {
                return;
            }
        });
        this.started = true;
    }

    public synchronized void stop() {
        if (!this.started) {
            throw new IllegalStateException("server does not started");
        }
        this.executor.shutdown();
        this.executor = null;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.serverSocket = null;
        this.started = false;
    }

    private static final class Connection
    implements Runnable {
        private final Socket socket;
        private final long timeout;
        private final Delegate delegate;
        private final ExecutorService executor;

        Connection(Socket socket, long timeout, ExecutorService executor, Delegate delegate) {
            this.socket = socket;
            this.timeout = timeout;
            this.delegate = delegate;
            this.executor = executor;
        }

        @Override
        public void run() {
            try {
                TimeGuard guard = new TimeGuard(this.timeout, () -> {
                    try (OutputStream os = this.socket.getOutputStream();
                         InputStream is = this.socket.getInputStream();){
                        Encoder encoder;
                        RequestDecoder decoder = Protocol.read(is).asRequest();
                        if (decoder == null) {
                            throw ProcBridgeException.malformedInputData();
                        }
                        String api = decoder.api;
                        JSONObject body = decoder.body;
                        try {
                            JSONObject reply = this.delegate.handleRequest(api, body);
                            encoder = new GoodResponseEncoder(reply);
                        }
                        catch (Exception ex) {
                            encoder = new BadResponseEncoder(ex.getMessage());
                        }
                        Protocol.write(os, encoder);
                    }
                    catch (ProcBridgeException | IOException e) {
                        throw new RuntimeException(e);
                    }
                });
                guard.execute(this.executor);
            }
            catch (ProcBridgeException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @FunctionalInterface
    public static interface Delegate {
        @Nullable
        public JSONObject handleRequest(@NotNull String var1, @NotNull JSONObject var2) throws Exception;
    }
}

