/*
 * Decompiled with CFR 0.152.
 */
package co.gongzh.procbridge;

import co.gongzh.procbridge.BadResponseDecoder;
import co.gongzh.procbridge.Decoder;
import co.gongzh.procbridge.Encoder;
import co.gongzh.procbridge.GoodResponseDecoder;
import co.gongzh.procbridge.ProcBridgeException;
import co.gongzh.procbridge.RequestDecoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

final class Protocol {
    private static final byte[] FLAG = new byte[]{112, 98};
    private static final byte[] VERSION = new byte[]{1, 0};
    static final String KEY_API = "api";
    static final String KEY_BODY = "body";
    static final String KEY_MESSAGE = "msg";

    Protocol() {
    }

    static void write(OutputStream stream, Encoder encoder) throws ProcBridgeException {
        try {
            stream.write(FLAG);
            stream.write(VERSION);
            stream.write(encoder.getStatusCode().rawValue);
            stream.write(0);
            stream.write(0);
            byte[] data = encoder.encode();
            int len = data.length;
            int b0 = len & 0xFF;
            int b1 = (len & 0xFF00) >> 8;
            int b2 = (len & 0xFF0000) >> 16;
            int b3 = (len & 0xFF000000) >> 24;
            stream.write(b0);
            stream.write(b1);
            stream.write(b2);
            stream.write(b3);
            stream.write(data);
            stream.flush();
        }
        catch (IOException e) {
            throw new ProcBridgeException(e);
        }
    }

    static Decoder read(InputStream stream) throws ProcBridgeException {
        try {
            int nRead;
            int b = stream.read();
            if (b == -1) {
                throw ProcBridgeException.unexpectedEndOfStream();
            }
            if (b != FLAG[0]) {
                throw ProcBridgeException.malformedInputData();
            }
            b = stream.read();
            if (b == -1) {
                throw ProcBridgeException.unexpectedEndOfStream();
            }
            if (b != FLAG[1]) {
                throw ProcBridgeException.malformedInputData();
            }
            b = stream.read();
            if (b == -1) {
                throw ProcBridgeException.unexpectedEndOfStream();
            }
            if (b != VERSION[0]) {
                throw ProcBridgeException.incompatibleVersion();
            }
            b = stream.read();
            if (b == -1) {
                throw ProcBridgeException.unexpectedEndOfStream();
            }
            if (b != VERSION[1]) {
                throw ProcBridgeException.incompatibleVersion();
            }
            b = stream.read();
            if (b == -1) {
                throw ProcBridgeException.unexpectedEndOfStream();
            }
            StatusCode statusCode = StatusCode.fromRawValue(b);
            if (statusCode == null) {
                throw ProcBridgeException.malformedInputData();
            }
            Decoder decoder = statusCode.makeDecoder();
            b = stream.read();
            if (b == -1) {
                throw ProcBridgeException.unexpectedEndOfStream();
            }
            b = stream.read();
            if (b == -1) {
                throw ProcBridgeException.unexpectedEndOfStream();
            }
            b = stream.read();
            if (b == -1) {
                throw ProcBridgeException.unexpectedEndOfStream();
            }
            int len = b;
            b = stream.read();
            if (b == -1) {
                throw ProcBridgeException.unexpectedEndOfStream();
            }
            len |= b << 8;
            b = stream.read();
            if (b == -1) {
                throw ProcBridgeException.unexpectedEndOfStream();
            }
            len |= b << 16;
            b = stream.read();
            if (b == -1) {
                throw ProcBridgeException.unexpectedEndOfStream();
            }
            if ((len |= b << 24) <= 0) {
                throw ProcBridgeException.malformedInputData();
            }
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = stream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
                if (buffer.size() < len) continue;
            }
            if (buffer.size() != len) {
                throw ProcBridgeException.malformedInputData();
            }
            buffer.flush();
            data = buffer.toByteArray();
            String jsonText = new String(data, "UTF-8");
            JSONObject obj = new JSONObject(jsonText);
            decoder.decode(obj);
            return decoder;
        }
        catch (IOException e) {
            throw new ProcBridgeException(e);
        }
        catch (JSONException e) {
            throw ProcBridgeException.malformedInputData();
        }
    }

    static enum StatusCode {
        REQUEST(0),
        RESPONSE_GOOD(1),
        RESPONSE_BAD(2);

        int rawValue;

        private StatusCode(int rawValue) {
            this.rawValue = rawValue;
        }

        @Nullable
        static StatusCode fromRawValue(int rawValue) {
            for (StatusCode sc : StatusCode.values()) {
                if (sc.rawValue != rawValue) continue;
                return sc;
            }
            return null;
        }

        @NotNull
        Decoder makeDecoder() throws ProcBridgeException {
            switch (this) {
                case REQUEST: {
                    return new RequestDecoder();
                }
                case RESPONSE_GOOD: {
                    return new GoodResponseDecoder();
                }
                case RESPONSE_BAD: {
                    return new BadResponseDecoder();
                }
            }
            throw new InternalError("unknown status code");
        }
    }
}

