﻿Param([Switch]$Cleanup)

if($Cleanup) {
  # Aufräumen
  Unregister-Event -SourceIdentifier NotepadDemo
  exit
}

### Hier beginnt das eigentliche Skript ###
function Global:HandleMyEvent($evt) {
  $Global:lastEvent = $evt

  $timeStamp = [DateTime]::FromFileTime($evt.SourceEventArgs.NewEvent.TIME_CREATED)
  Write-Host "${timeStamp}: Treffer!"
}

$query = 'select *
  from Win32_ProcessStartTrace
  where ProcessName="Notepad.exe"'
Register-CimIndicationEvent `
  -SourceIdentifier NotepadDemo `
  -Query $query `
  -Action { HandleMyEvent $event }
