﻿Param([Switch]$Cleanup)

if($Cleanup) {
  # Aufräumen
  Unregister-Event -SourceIdentifier PrintJobDemo
  exit
}

### Hier beginnt das eigentliche Skript ###
function Global:HandleMyEvent($evt) {
  $Global:lastEvent = $evt

  $job = $evt.SourceEventArgs.NewEvent.TargetInstance
  Write-Host "Druck-Job `"$($job.Name)`" ist fertig!"
}

$query = 'select *
  from __InstanceDeletionEvent
  within 2
  where TargetInstance isa "Win32_PrintJob"'
Register-CimIndicationEvent `
  -SourceIdentifier PrintJobDemo `
  -Query $query `
  -Action { HandleMyEvent $event }
