@echo off
setlocal enabledelayedexpansion

rem Der Batch-Teil stammt aus c't 8/2019, S. 168
set power=0
if exist %temp%\%~n0.ps1 del %temp%\%~n0.ps1
for /f "tokens=*" %%l in ('type "%~f0"') do (
  if !power!==0 (
    if "%%l"=="*** Ab hier PowerShell ***" set power=1
  ) else (
    echo %%l >> %temp%\%~n0.ps1
  )
)
powershell -NoProfile -ExecutionPolicy Bypass -File %temp%\%~n0.ps1 %*
del %temp%\%~n0.ps1
rem pause
exit /b

*** Ab hier PowerShell ***
Param (
    [Parameter(Mandatory=$true)]
    [string]$ProductKey
)

$ProductKey = $ProductKey.ToUpper().Trim(@(' ', '"', "'"))
if($ProductKey -match '^[A-Z0-9]{25}$') {
    $ProductKey = $ProductKey.Substring( 0, 5) + '-' + $ProductKey.Substring( 5, 5) + '-' + 
                  $ProductKey.Substring(10, 5) + '-' + $ProductKey.Substring(15, 5) + '-' + 
                  $ProductKey.Substring(20, 5)
}
if(-not ($ProductKey -match '^([A-Z0-9]{5}-){4}[A-Z0-9]{5}$')) {
    'Fehler: Der Produktschlssel muss nach dem Muster XXXXX-XXXXX-XXXXX-XXXXX-XXXXX aufgebaut sein.'
    return
}
$sha256 = [System.Security.Cryptography.HashAlgorithm]::Create('sha256')
$hash = $sha256.ComputeHash([System.Text.Encoding]::UTF8.GetBytes($ProductKey))
$hashBuffer = New-Object System.Text.StringBuilder
foreach($byte in $hash) {
    $hashBuffer.Append('{0:x2}' -f $byte) | Out-Null
}
"Bitte schicken Sie folgenden Hash und die Info, zu welchem Produkt der"
"Schlssel gehrt, an hashmich@ct.de:`r`n"
$hashBuffer.ToString()
